
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class EditForumTopic(TLRequest[TypeUpdates]):
    """
    Edit [forum topic](https://core.telegram.org/api/forum); requires [manage_topics rights](https://core.telegram.org/api/rights).

    **Bots can use this method**

    Raises:
        `400`ChannelForumMissingError: This supergroup is not a forum.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`DocumentInvalidError: The specified document is invalid.
        `400`GeneralModifyIconForbiddenError: You can't modify the icon of the "General" topic.
        `400`TopicCloseSeparatelyError: The `close` flag cannot be provided together with any of the other flags.
        `400`TopicHideSeparatelyError: The `hide` flag cannot be provided together with any of the other flags.
        `400`TopicIdInvalidError: The specified topic ID is invalid.
        `400`TopicNotModifiedError: The updated topic info is equal to the current topic info, nothing was changed.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.

    """

    _id = 0XF4DFA185
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        topic_id: int,
        title: Optional[str] = None,
        icon_emoji_id: Optional[int] = None,
        closed: bool = False,
        hidden: bool = False
    ):

        """
        Edit [forum topic](https://core.telegram.org/api/forum); requires [manage_topics rights](https://core.telegram.org/api/rights).

        **Bots can use this method**

        Args:
            channel ('TypeInputChannel'): Supergroup
            topic_id (int): Topic ID
            title (Optional[str], optional): If present, will update the topic title (maximum UTF-8 length: 128).
            icon_emoji_id (Optional[int], optional): If present, updates the [custom emoji](https://core.telegram.org/api/custom-emoji) used as topic icon. [Telegram Premium](https://core.telegram.org/api/premium) users can use any custom emoji, other users can only use the custom emojis contained in the [inputStickerSetEmojiDefaultTopicIcons](https://core.telegram.org/constructor/inputStickerSetEmojiDefaultTopicIcons) emoji pack. Pass 0 to switch to the fallback topic icon.
            closed (bool, optional): If present, will update the open/closed status of the topic.
            hidden (bool, optional): If present, will hide/unhide the topic (only valid for the "General" topic, id=1).
        """

        self.channel = channel
        self.topic_id = topic_id
        self.title = title
        self.icon_emoji_id = icon_emoji_id
        self.closed = closed
        self.hidden = hidden

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x85\xa1\xdf\xf4' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.int(self.topic_id)

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.icon_emoji_id, 1):
                    writer.long(self.icon_emoji_id)

                if flags(self.closed, 2):
                    writer.object(
                        self.closed,
                        group_id=0X43B904E1
                    )

                if flags(self.hidden, 3):
                    writer.object(
                        self.hidden,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()