
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.messages import TypeMessagesMessages


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class SearchPosts(TLRequest[TypeMessagesMessages]):
    """
    Globally search for posts from public [channels](https://core.telegram.org/api/channel) ( including those we aren't a member of) containing a specific hashtag.
    """

    _id = 0XF2C4F24D
    _result_id = 0XC8BB9188

    def __init__(
        self,
        offset_rate: int,
        offset_peer: 'TypeInputPeer',
        offset_id: int,
        limit: int,
        hashtag: Optional[str] = None,
        query: Optional[str] = None,
        allow_paid_stars: Optional[int] = None
    ):

        """
        Globally search for posts from public [channels](https://core.telegram.org/api/channel) ( including those we aren't a member of) containing a specific hashtag.

        Args:
            offset_rate (int): Initially 0, then set to the [next_rate parameter of messages.messagesSlice](https://core.telegram.org/constructor/messages.messagesSlice)
            offset_peer ('TypeInputPeer'): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            hashtag (Optional[str], optional): The hashtag to search, without the # character.
            query (Optional[str], optional): ...
            allow_paid_stars (Optional[int], optional): ...
        """

        self.offset_rate = offset_rate
        self.offset_peer = offset_peer
        self.offset_id = offset_id
        self.limit = limit
        self.hashtag = hashtag
        self.query = query
        self.allow_paid_stars = allow_paid_stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'M\xf2\xc4\xf2' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.hashtag, 0):
                    writer.string(self.hashtag)

                if flags(self.query, 1):
                    writer.string(self.query)
                writer.int(self.offset_rate)
                writer.object(
                    self.offset_peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.offset_id)
                writer.int(self.limit)

                if flags(self.allow_paid_stars, 2):
                    writer.long(self.allow_paid_stars)

            return writer.getvalue()