
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class UpdateColor(TLRequest[TypeUpdates]):
    """
    Update the [accent color and background custom emoji](https://core.telegram.org/api/colors) of a channel.

    Raises:
        `400`BoostsRequiredError: The specified channel must first be [boosted by its users](https://core.telegram.org/api/boost) in order to perform this action.
        `400`ChannelInvalidError: The provided channel is invalid.

    """

    _id = 0XD8AA3671
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        for_profile: bool = False,
        color: Optional[int] = None,
        background_emoji_id: Optional[int] = None
    ):

        """
        Update the [accent color and background custom emoji](https://core.telegram.org/api/colors) of a channel.

        Args:
            channel ('TypeInputChannel'): Channel whose accent color should be changed.
            for_profile (bool, optional): Whether to change the accent color emoji pattern of the profile page; otherwise, the accent color and emoji pattern of messages will be changed. Channels can change both message and profile palettes; supergroups can only change the profile palette, of course after reaching the [appropriate boost level](https://core.telegram.org/api/colors).
            color (Optional[int], optional): [ID of the accent color palette](https://core.telegram.org/api/colors) to use (not RGB24, see [here](https://core.telegram.org/api/colors) for more info); if not set, the default palette is used.
            background_emoji_id (Optional[int], optional): Custom emoji ID used in the accent color pattern.
        """

        self.channel = channel
        self.for_profile = for_profile
        self.color = color
        self.background_emoji_id = background_emoji_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'q6\xaa\xd8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.for_profile, 1)
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )

                if flags(self.color, 2):
                    writer.int(self.color)

                if flags(self.background_emoji_id, 0):
                    writer.long(self.background_emoji_id)

            return writer.getvalue()