
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser


class AddContact(TLRequest[TypeUpdates]):
    """
    Add an existing telegram user as contact.

    Raises:
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ContactIdInvalidError: The provided contact ID is invalid.
        `400`ContactNameEmptyError: Contact name empty.
        `400`MsgIdInvalidError: Invalid message ID provided.

    """

    _id = 0XE8F463D0
    _result_id = 0XD68D29C0

    def __init__(
        self,
        id: 'TypeInputUser',
        first_name: str,
        last_name: str,
        phone: str,
        add_phone_privacy_exception: bool = False
    ):

        """
        Add an existing telegram user as contact.

        Args:
            id ('TypeInputUser'): Telegram ID of the other user
            first_name (str): First name
            last_name (str): Last name
            phone (str): User's phone number, may be omitted to simply add the user to the contact list, without a phone number.
            add_phone_privacy_exception (bool, optional): Allow the other user to see our phone number?
        """

        self.id = id
        self.first_name = first_name
        self.last_name = last_name
        self.phone = phone
        self.add_phone_privacy_exception = add_phone_privacy_exception

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd0c\xf4\xe8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.add_phone_privacy_exception, 0)
                writer.object(
                    self.id,
                    group_id=0XB628962F
                )
                writer.string(self.first_name)
                writer.string(self.last_name)
                writer.string(self.phone)

            return writer.getvalue()