
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.contacts.top_peers import TypeContactsTopPeers


class GetTopPeers(TLRequest[TypeContactsTopPeers]):
    """
    Get most used peers

    Raises:
        `400`TypesEmptyError: No top peer type was provided.

    """

    _id = 0X973478B6
    _result_id = 0X15AC5C95

    def __init__(
        self,
        offset: int,
        limit: int,
        hash: int,
        correspondents: bool = False,
        bots_pm: bool = False,
        bots_inline: bool = False,
        phone_calls: bool = False,
        forward_users: bool = False,
        forward_chats: bool = False,
        groups: bool = False,
        channels: bool = False,
        bots_app: bool = False
    ):

        """
        Get most used peers

        Args:
            offset (int): Offset for [pagination](https://core.telegram.org/api/offsets)
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            correspondents (bool, optional): Users we've chatted most frequently with
            bots_pm (bool, optional): Most used bots
            bots_inline (bool, optional): Most used inline bots
            phone_calls (bool, optional): Most frequently called users
            forward_users (bool, optional): Users to which the users often forwards messages to
            forward_chats (bool, optional): Chats to which the users often forwards messages to
            groups (bool, optional): Often-opened groups and supergroups
            channels (bool, optional): Most frequently visited channels
            bots_app (bool, optional): Most frequently used [Main Mini Bot Apps](https://core.telegram.org/api/bots/webapps#main-mini-apps).
        """

        self.offset = offset
        self.limit = limit
        self.hash = hash
        self.correspondents = correspondents
        self.bots_pm = bots_pm
        self.bots_inline = bots_inline
        self.phone_calls = phone_calls
        self.forward_users = forward_users
        self.forward_chats = forward_chats
        self.groups = groups
        self.channels = channels
        self.bots_app = bots_app

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb6x4\x97' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.correspondents, 0)
                flags(self.bots_pm, 1)
                flags(self.bots_inline, 2)
                flags(self.phone_calls, 3)
                flags(self.forward_users, 4)
                flags(self.forward_chats, 5)
                flags(self.groups, 10)
                flags(self.channels, 15)
                flags(self.bots_app, 16)
                writer.int(self.offset)
                writer.int(self.limit)
                writer.long(self.hash)

            return writer.getvalue()