
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class EditChatTitle(TLRequest[TypeUpdates]):
    """
    Changes chat name and sends a service message on it.

    **Bots can use this method**

    Raises:
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ChatNotModifiedError: No changes were made to chat information because the new information you passed is identical to the current information.
        `400`ChatTitleEmptyError: No chat title provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X73783FFD
    _result_id = 0XD68D29C0

    def __init__(
        self,
        chat_id: int,
        title: str
    ):

        """
        Changes chat name and sends a service message on it.

        **Bots can use this method**

        Args:
            chat_id (int): Chat ID
            title (str): New chat name, different from the old one
        """

        self.chat_id = chat_id
        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfd?xs' if boxed else b'') as writer:
            writer.long(self.chat_id)
            writer.string(self.title)

            return writer.getvalue()