
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.exported_chat_invite import TypeMessagesExportedChatInvite


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class EditExportedChatInvite(TLRequest[TypeMessagesExportedChatInvite]):
    """
    Edit an exported chat invite

    **Bots can use this method**

    Raises:
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatInvitePermanentError: You can't set an expiration date on permanent invite links.
        `400`InviteHashExpiredError: The invite link has expired.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UsageLimitInvalidError: The specified usage limit is invalid.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`EditBotInviteForbiddenError: Normal users can't edit invites that were created by bots.

    """

    _id = 0XBDCA2F75
    _result_id = 0XF6360772

    def __init__(
        self,
        peer: 'TypeInputPeer',
        link: str,
        revoked: bool = False,
        expire_date: Optional[int] = None,
        usage_limit: Optional[int] = None,
        request_needed: bool = False,
        title: Optional[str] = None
    ):

        """
        Edit an exported chat invite

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Chat
            link (str): Invite link
            revoked (bool, optional): Whether to revoke the chat invite
            expire_date (Optional[int], optional): New expiration date
            usage_limit (Optional[int], optional): Maximum number of users that can join using this link
            request_needed (bool, optional): Whether admin confirmation is required before admitting each separate user into the chat
            title (Optional[str], optional): Description of the invite link, visible only to administrators
        """

        self.peer = peer
        self.link = link
        self.revoked = revoked
        self.expire_date = expire_date
        self.usage_limit = usage_limit
        self.request_needed = request_needed
        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'u/\xca\xbd' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.revoked, 2)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.string(self.link)

                if flags(self.expire_date, 0):
                    writer.int(self.expire_date)

                if flags(self.usage_limit, 1):
                    writer.int(self.usage_limit)

                if flags(self.request_needed, 3):
                    writer.object(
                        self.request_needed,
                        group_id=0X43B904E1
                    )

                if flags(self.title, 4):
                    writer.string(self.title)

            return writer.getvalue()