
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_media import TypeInputMedia
    from ...types.reply_markup import TypeReplyMarkup
    from ...types.message_entity import TypeMessageEntity


class EditMessage(TLRequest[TypeUpdates]):
    """
    Edit message

    **Bots can use this method**

    Raises:
        `400`BotDomainInvalidError: Bot domain invalid.
        `400`BotInvalidError: This is not a valid bot.
        `400`ButtonCopyTextInvalidError: The specified [keyboardButtonCopy](https://core.telegram.org/constructor/keyboardButtonCopy).`copy_text` is invalid.
        `400`ButtonDataInvalidError: The data of one or more of the buttons you provided is invalid.
        `400`ButtonTypeInvalidError: The type of one or more of the buttons you provided is invalid.
        `400`ButtonUrlInvalidError: Button URL invalid.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatForwardsRestrictedError: You can't forward messages from a protected chat.
        `400`DocumentInvalidError: The specified document is invalid.
        `400`EntitiesTooLongError: You provided too many styled message entities.
        `400`EntityBoundsInvalidError: A specified [entity offset or length](https://core.telegram.org/api/entities#entity-length) is invalid, see [here &raquo;](https://core.telegram.org/api/entities#entity-length) for info on how to properly compute the entity offset/length.
        `400`FilePartsInvalidError: The number of file parts is invalid.
        `400`ImageProcessFailedError: Failure while processing image.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MediaCaptionTooLongError: The caption is too long.
        `400`MediaEmptyError: The provided media object is invalid.
        `400`MediaGroupedInvalidError: You tried to send media of different types in an album.
        `400`MediaInvalidError: Media invalid.
        `400`MediaNewInvalidError: The new media is invalid.
        `400`MediaPrevInvalidError: Previous media invalid.
        `400`MediaTtlInvalidError: The specified media TTL is invalid.
        `400`MessageEditTimeExpiredError: You can't edit this message anymore, too much time has passed since its creation.
        `400`MessageEmptyError: The provided message is empty.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`MessageNotModifiedError: The provided message data is identical to the previous message data, the message wasn't modified.
        `400`MessageTooLongError: The provided message is too long.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`PeerTypesInvalidError: The passed [keyboardButtonSwitchInline](https://core.telegram.org/constructor/keyboardButtonSwitchInline).`peer_types` field is invalid.
        `400`ReplyMarkupInvalidError: The provided reply markup is invalid.
        `400`ReplyMarkupTooLongError: The specified reply_markup is too long.
        `400`ScheduleDateInvalidError: Invalid schedule date provided.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `400`WebpageNotFoundError: A preview for the specified webpage `url` could not be generated.
        `406`ChannelPrivateError: You haven't joined this channel/supergroup.
        `403`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `403`ChatSendGifsForbiddenError: You can't send gifs in this chat.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`InlineBotRequiredError: Only the inline bot can edit message.
        `403`MessageAuthorRequiredError: Message author required.
        `500`MsgWaitFailedError: A waiting call returned an error.

    """

    _id = 0XDFD14005
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        no_webpage: bool = False,
        invert_media: bool = False,
        message: Optional[str] = None,
        media: Optional['TypeInputMedia'] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        schedule_date: Optional[int] = None,
        quick_reply_shortcut_id: Optional[int] = None
    ):

        """
        Edit message

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): Where was the message sent
            id (int): ID of the message to edit
            no_webpage (bool, optional): Disable webpage preview
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            message (Optional[str], optional): New message
            media (Optional['TypeInputMedia'], optional): New attached media
            reply_markup (Optional['TypeReplyMarkup'], optional): Reply markup for inline keyboards
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            schedule_date (Optional[int], optional): Scheduled message date for [scheduled messages](https://core.telegram.org/api/scheduled-messages)
            quick_reply_shortcut_id (Optional[int], optional): If specified, edits a [quick reply shortcut message, instead](https://core.telegram.org/api/business#quick-reply-shortcuts).
        """

        self.peer = peer
        self.id = id
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.message = message
        self.media = media
        self.reply_markup = reply_markup
        self.entities = entities
        self.schedule_date = schedule_date
        self.quick_reply_shortcut_id = quick_reply_shortcut_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x05@\xd1\xdf' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_webpage, 1)
                flags(self.invert_media, 16)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)

                if flags(self.message, 11):
                    writer.string(self.message)

                if flags(self.media, 14):
                    writer.object(
                        self.media,
                        group_id=0XCEC6DE21
                    )

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

                if flags(self.entities, 3):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.schedule_date, 15):
                    writer.int(self.schedule_date)

                if flags(self.quick_reply_shortcut_id, 17):
                    writer.int(self.quick_reply_shortcut_id)

            return writer.getvalue()