
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.messages import TypeMessagesMessages


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetUnreadReactions(TLRequest[TypeMessagesMessages]):
    """
    Get unread reactions to messages you sent

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XBD7F90AC
    _result_id = 0XC8BB9188

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset_id: int,
        add_offset: int,
        limit: int,
        max_id: int,
        min_id: int,
        top_msg_id: Optional[int] = None,
        saved_peer_id: Optional['TypeInputPeer'] = None
    ):

        """
        Get unread reactions to messages you sent

        Args:
            peer ('TypeInputPeer'): Peer
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            add_offset (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            max_id (int): Only return reactions for messages up until this message ID
            min_id (int): Only return reactions for messages starting from this message ID
            top_msg_id (Optional[int], optional): If set, considers only reactions to messages within the specified [forum topic](https://core.telegram.org/api/forum#forum-topics)
            saved_peer_id (Optional['TypeInputPeer'], optional): ...
        """

        self.peer = peer
        self.offset_id = offset_id
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id
        self.top_msg_id = top_msg_id
        self.saved_peer_id = saved_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xac\x90\x7f\xbd' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)

                if flags(self.saved_peer_id, 1):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0X995DB9DF
                    )
                writer.int(self.offset_id)
                writer.int(self.add_offset)
                writer.int(self.limit)
                writer.int(self.max_id)
                writer.int(self.min_id)

            return writer.getvalue()