
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer, Long


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class SendQuickReplyMessages(TLRequest[TypeUpdates]):
    """
    Send a [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts).

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `403`PremiumAccountRequiredError: A premium account is required to execute this action.

    """

    _id = 0X6C750DE1
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        shortcut_id: int,
        id: List[int],
        random_id: List[int] = None
    ):

        """
        Send a [quick reply shortcut](https://core.telegram.org/api/business#quick-reply-shortcuts).

        Args:
            peer ('TypeInputPeer'): The peer where to send the shortcut (users only, for now).
            shortcut_id (int): The ID of the quick reply shortcut to send.
            id (List[int]): Specify a subset of messages from the shortcut to send; if empty, defaults to all of them.
            random_id (List[int], optional): Unique client IDs required to prevent message resending, one for each message we're sending, may be empty (but not recommended).
        """

        self.peer = peer
        self.shortcut_id = shortcut_id
        self.id = id
        self.random_id = [Long() for _ in id] if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1\rul' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.shortcut_id)
            writer.vector(
                self.id,
                writer.int
            )
            writer.vector(
                self.random_id,
                writer.long
            )

            return writer.getvalue()