
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.shipping_option import TypeShippingOption


class SetBotShippingResults(TLRequest[bool]):
    """
    If you sent an invoice requesting a shipping address and the parameter is_flexible was specified, the bot will receive an [updateBotShippingQuery](https://core.telegram.org/constructor/updateBotShippingQuery) update. Use this method to reply to shipping queries.

    **Bots can use this method**

    Raises:
        `400`QueryIdInvalidError: The query ID is invalid.
        `400`UserBotRequiredError: This method can only be called by a bot.

    """

    _id = 0XE5F672FA
    _result_id = 0X43B904E1

    def __init__(
        self,
        query_id: int,
        error: Optional[str] = None,
        shipping_options: Optional[List['TypeShippingOption']] = None
    ):

        """
        If you sent an invoice requesting a shipping address and the parameter is_flexible was specified, the bot will receive an [updateBotShippingQuery](https://core.telegram.org/constructor/updateBotShippingQuery) update. Use this method to reply to shipping queries.

        **Bots can use this method**

        Args:
            query_id (int): Unique identifier for the query to be answered
            error (Optional[str], optional): Error message in human readable form that explains why it is impossible to complete the order (e.g. "Sorry, delivery to your desired address is unavailable"). Telegram will display this message to the user.
            shipping_options (Optional[List['TypeShippingOption']], optional): A vector of available shipping options.
        """

        self.query_id = query_id
        self.error = error
        self.shipping_options = shipping_options

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfar\xf6\xe5' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.query_id)

                if flags(self.error, 0):
                    writer.string(self.error)

                if flags(self.shipping_options, 1):
                    writer.vector(
                        self.shipping_options,
                        lambda value: writer.object(
                            value,
                            group_id=0X76120353
                        )
                    )

            return writer.getvalue()