
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.sticker_set import TypeMessagesStickerSet


if TYPE_CHECKING:
    from ...types.input_document import TypeInputDocument
    from ...types.input_sticker_set import TypeInputStickerSet


class SetStickerSetThumb(TLRequest[TypeMessagesStickerSet]):
    """
    Set stickerset thumbnail

    **Bots can use this method**

    Raises:
        `400`StickersetInvalidError: The provided sticker set is invalid.
        `400`StickerThumbPngNopngError: Incorrect stickerset thumb file provided, PNG / WEBP expected.
        `400`StickerThumbTgsNotgsError: Incorrect stickerset TGS thumb file provided.

    """

    _id = 0XA76A5392
    _result_id = 0X5CC84E96

    def __init__(
        self,
        stickerset: 'TypeInputStickerSet',
        thumb: Optional['TypeInputDocument'] = None,
        thumb_document_id: Optional[int] = None
    ):

        """
        Set stickerset thumbnail

        **Bots can use this method**

        Args:
            stickerset ('TypeInputStickerSet'): Stickerset
            thumb (Optional['TypeInputDocument'], optional): Thumbnail (only for normal stickersets, not custom emoji stickersets).
            thumb_document_id (Optional[int], optional): Only for [custom emoji stickersets](https://core.telegram.org/api/custom-emoji), ID of a custom emoji present in the set to use as thumbnail; pass 0 to fallback to the first custom emoji of the set.
        """

        self.stickerset = stickerset
        self.thumb = thumb
        self.thumb_document_id = thumb_document_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x92Sj\xa7' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.stickerset,
                    group_id=0X919D8BA5
                )

                if flags(self.thumb, 0):
                    writer.object(
                        self.thumb,
                        group_id=0X84313E
                    )

                if flags(self.thumb_document_id, 1):
                    writer.long(self.thumb_document_id)

            return writer.getvalue()