
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.stories.story_reactions_list import TypeStoriesStoryReactionsList


if TYPE_CHECKING:
    from ...types.reaction import TypeReaction
    from ...types.input_peer import TypeInputPeer


class GetStoryReactionsList(TLRequest[TypeStoriesStoryReactionsList]):
    """
    Get the [reaction](https://core.telegram.org/api/reactions) and interaction list of a [story](https://core.telegram.org/api/stories) posted to a channel, along with the sender of each reaction.

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XB9B2881F
    _result_id = 0X9C56A0C1

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        limit: int,
        forwards_first: bool = False,
        reaction: Optional['TypeReaction'] = None,
        offset: Optional[str] = None
    ):

        """
        Get the [reaction](https://core.telegram.org/api/reactions) and interaction list of a [story](https://core.telegram.org/api/stories) posted to a channel, along with the sender of each reaction.

        Args:
            peer ('TypeInputPeer'): Channel
            id (int): [Story](https://core.telegram.org/api/stories) ID
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            forwards_first (bool, optional): If set, returns forwards and reposts first, then reactions, then other views; otherwise returns interactions sorted just by interaction date.
            reaction (Optional['TypeReaction'], optional): Get only reactions of this type
            offset (Optional[str], optional): Offset for pagination (taken from the next_offset field of the returned [stories.StoryReactionsList](https://core.telegram.org/type/stories.StoryReactionsList)); empty in the first request.
        """

        self.peer = peer
        self.id = id
        self.limit = limit
        self.forwards_first = forwards_first
        self.reaction = reaction
        self.offset = offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1f\x88\xb2\xb9' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.forwards_first, 2)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)

                if flags(self.reaction, 0):
                    writer.object(
                        self.reaction,
                        group_id=0X19F930D1
                    )

                if flags(self.offset, 1):
                    writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()