
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.stories.story_views_list import TypeStoriesStoryViewsList


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetStoryViewsList(TLRequest[TypeStoriesStoryViewsList]):
    """
    Obtain the list of users that have viewed a specific [story we posted](https://core.telegram.org/api/stories)

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`StoryIdInvalidError: The specified story ID is invalid.

    """

    _id = 0X7ED23C57
    _result_id = 0X408F23A6

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        offset: str,
        limit: int,
        just_contacts: bool = False,
        reactions_first: bool = False,
        forwards_first: bool = False,
        q: Optional[str] = None
    ):

        """
        Obtain the list of users that have viewed a specific [story we posted](https://core.telegram.org/api/stories)

        Args:
            peer ('TypeInputPeer'): Peer where the story was posted
            id (int): Story ID
            offset (str): Offset for pagination, obtained from [stories.storyViewsList](https://core.telegram.org/constructor/stories.storyViewsList). next_offset
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            just_contacts (bool, optional): Whether to only fetch view reaction/views made by our [contacts](https://core.telegram.org/api/contacts)
            reactions_first (bool, optional): Whether to return [storyView](https://core.telegram.org/constructor/storyView) info about users that reacted to the story (i.e. if set, the server will first sort results by view date as usual, and then also additionally sort the list by putting [storyView](https://core.telegram.org/constructor/storyView)s with an associated reaction first in the list). Ignored if forwards_first is set.
            forwards_first (bool, optional): If set, returns forwards and reposts first, then reactions, then other views; otherwise returns interactions sorted just by interaction date.
            q (Optional[str], optional): Search for specific peers
        """

        self.peer = peer
        self.id = id
        self.offset = offset
        self.limit = limit
        self.just_contacts = just_contacts
        self.reactions_first = reactions_first
        self.forwards_first = forwards_first
        self.q = q

    def to_bytes(self, boxed: bool=True):
        with Writer(b'W<\xd2~' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.just_contacts, 0)
                flags(self.reactions_first, 2)
                flags(self.forwards_first, 3)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.q, 1):
                    writer.string(self.q)
                writer.int(self.id)
                writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()