
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer, Long


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.media_area import TypeMediaArea
    from ...types.input_media import TypeInputMedia
    from ...types.message_entity import TypeMessageEntity
    from ...types.input_privacy_rule import TypeInputPrivacyRule


class SendStory(TLRequest[TypeUpdates]):
    """
    Uploads a [Telegram Story](https://core.telegram.org/api/stories).

    Raises:
        `400`BoostsRequiredError: The specified channel must first be [boosted by its users](https://core.telegram.org/api/boost) in order to perform this action.
        `400`ImageProcessFailedError: Failure while processing image.
        `400`MediaEmptyError: The provided media object is invalid.
        `400`MediaFileInvalidError: The specified media file is invalid.
        `400`MediaTypeInvalidError: The specified media type cannot be used in stories.
        `400`MediaVideoStoryMissingError: A non-story video cannot be repubblished as a story (emitted when trying to resend a non-story video as a story using inputDocument).
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`PremiumAccountRequiredError: A premium account is required to execute this action.
        `400`StoriesTooMuchError: You have hit the maximum active stories limit as specified by the [`story_expiring_limit_*` client configuration parameters](https://core.telegram.org/api/config#story-expiring-limit-default): you should buy a [Premium](https://core.telegram.org/api/premium) subscription, delete an active story, or wait for the oldest story to expire.
        `400`StoryPeriodInvalidError: The specified story period is invalid for this account.
        `400`VenueIdInvalidError: The specified venue ID is invalid.

    """

    _id = 0X737FC2EC
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        media: 'TypeInputMedia',
        privacy_rules: List['TypeInputPrivacyRule'],
        pinned: bool = False,
        noforwards: bool = False,
        fwd_modified: bool = False,
        media_areas: Optional[List['TypeMediaArea']] = None,
        caption: Optional[str] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        period: Optional[int] = None,
        fwd_from_id: Optional['TypeInputPeer'] = None,
        fwd_from_story: Optional[int] = None,
        albums: Optional[List[int]] = None,
        random_id: int = None
    ):

        """
        Uploads a [Telegram Story](https://core.telegram.org/api/stories).

        Args:
            peer ('TypeInputPeer'): The peer to send the story as.
            media ('TypeInputMedia'): The story media.
            privacy_rules (List['TypeInputPrivacyRule']): [Privacy rules](https://core.telegram.org/api/privacy) for the story, indicating who can or can't view the story.
            pinned (bool, optional): Whether to add the story to the profile automatically upon expiration. If not set, the story will only be added to the archive, see [here](https://core.telegram.org/api/stories) for more info.
            noforwards (bool, optional): If set, disables forwards, screenshots, and downloads.
            fwd_modified (bool, optional): Set this flag when reposting stories with fwd_from_id+ fwd_from_id, if the media was modified before reposting.
            media_areas (Optional[List['TypeMediaArea']], optional): [Media areas](https://core.telegram.org/api/stories#media-areas) associated to the story, see [here](https://core.telegram.org/api/stories#media-areas) for more info.
            caption (Optional[str], optional): Story caption.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities), if allowed by the [stories_entities client configuration parameter](https://core.telegram.org/api/config#stories-entities).
            period (Optional[int], optional): Period after which the story is moved to archive (and to the profile if pinned is set), in seconds; must be one of 6 * 3600, 12 * 3600, 86400, or 2 * 86400 for Telegram Premium users, and 86400 otherwise.
            fwd_from_id (Optional['TypeInputPeer'], optional): If set, indicates that this story is a repost of story with ID fwd_from_story posted by the peer in fwd_from_id.
            fwd_from_story (Optional[int], optional): If set, indicates that this story is a repost of story with ID fwd_from_story posted by the peer in fwd_from_id.
            albums (Optional[List[int]], optional): ...
            random_id (int, optional): Unique client message ID required to prevent message resending.
        """

        self.peer = peer
        self.media = media
        self.privacy_rules = privacy_rules
        self.pinned = pinned
        self.noforwards = noforwards
        self.fwd_modified = fwd_modified
        self.media_areas = media_areas
        self.caption = caption
        self.entities = entities
        self.period = period
        self.fwd_from_id = fwd_from_id
        self.fwd_from_story = fwd_from_story
        self.albums = albums
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xec\xc2\x7fs' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 2)
                flags(self.noforwards, 4)
                flags(self.fwd_modified, 7)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.media,
                    group_id=0XCEC6DE21
                )

                if flags(self.media_areas, 5):
                    writer.vector(
                        self.media_areas,
                        lambda value: writer.object(
                            value,
                            group_id=0XA32C529B
                        )
                    )

                if flags(self.caption, 0):
                    writer.string(self.caption)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )
                writer.vector(
                    self.privacy_rules,
                    lambda value: writer.object(
                        value,
                        group_id=0XCA2848B1
                    )
                )
                writer.long(self.random_id)

                if flags(self.period, 3):
                    writer.int(self.period)

                if flags(self.fwd_from_id, 6):
                    writer.object(
                        self.fwd_from_id,
                        group_id=0X995DB9DF
                    )

                if flags(self.fwd_from_story, 6):
                    writer.int(self.fwd_from_story)

                if flags(self.albums, 8):
                    writer.vector(
                        self.albums,
                        writer.int
                    )

            return writer.getvalue()