
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.upload.file import TypeUploadFile
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_file_location import TypeInputFileLocation


class GetFile(TLRequest[TypeUploadFile]):
    """
    Returns content of a whole file or its part.

    **Bots can use this method**

    Raises:
        `400`CdnMethodInvalidError: You can't call this method in a CDN DC.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`FileIdInvalidError: The provided file id is invalid.
        `400`FileReferenceEmptyError: An empty [file reference](https://core.telegram.org/api/file_reference) was specified.
        `400`FileReferenceExpiredError: File reference expired, it must be refetched as described in [the documentation](https://core.telegram.org/api/file_reference).
        `400`LimitInvalidError: The provided limit is invalid.
        `400`LocationInvalidError: The provided location is invalid.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`OffsetInvalidError: The provided offset is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `406`FilerefUpgradeNeededError: The client has to be updated in order to support [file references](https://core.telegram.org/api/file_reference).
        `420`FloodPremiumWaitError: Please wait {seconds} seconds before repeating the action, or purchase a [Telegram Premium subscription](https://core.telegram.org/api/premium) to remove this rate limit.

    """

    _id = 0XBE5335BE
    _result_id = 0X2063BCC2

    def __init__(
        self,
        location: 'TypeInputFileLocation',
        offset: int,
        limit: int,
        precise: bool = False,
        cdn_supported: bool = False
    ):

        """
        Returns content of a whole file or its part.

        **Bots can use this method**

        Args:
            location ('TypeInputFileLocation'): File location
            offset (int): Number of bytes to be skipped
            limit (int): Number of bytes to be returned
            precise (bool, optional): Disable some checks on limit and offset values, useful for example to stream videos by keyframes
            cdn_supported (bool, optional): Whether the current client supports [CDN downloads](https://core.telegram.org/cdn)
        """

        self.location = location
        self.offset = offset
        self.limit = limit
        self.precise = precise
        self.cdn_supported = cdn_supported

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbe5S\xbe' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.precise, 0)
                flags(self.cdn_supported, 1)
                writer.object(
                    self.location,
                    group_id=0X7CB505BF
                )
                writer.long(self.offset)
                writer.int(self.limit)

            return writer.getvalue()