
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer, Long


if TYPE_CHECKING:
    from .message_entity import TypeMessageEntity
    from ...gadgets.byteutils import Reader
    from .decrypted_message_media import TypeDecryptedMessageMedia
    from .decrypted_message_action import TypeDecryptedMessageAction


class DecryptedMessage8(TLObject, family='TypeDecryptedMessage'):
    _id = 0X1F814F1F
    _group_id = 0XC3103AAD

    def __init__(
        self,
        random_bytes: bytes,
        message: str,
        media: 'TypeDecryptedMessageMedia',
        random_id: int = None
    ):

        self.random_bytes = random_bytes
        self.message = message
        self.media = media
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1fO\x81\x1f' if boxed else b'') as writer:
            writer.long(self.random_id)
            writer.bytes(self.random_bytes)
            writer.string(self.message)
            writer.object(
                self.media,
                group_id=0X403DEA17
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        random_id_ = reader.long()
        random_bytes_ = reader.bytes()
        message_ = reader.string()
        media_ = reader.object(
            group_id=0X403DEA17
        )

        return cls(
            random_id=random_id_,
            random_bytes=random_bytes_,
            message=message_,
            media=media_
        )

class DecryptedMessageService8(TLObject, family='TypeDecryptedMessage'):
    _id = 0XAA48327D
    _group_id = 0XC3103AAD

    def __init__(
        self,
        random_bytes: bytes,
        action: 'TypeDecryptedMessageAction',
        random_id: int = None
    ):

        self.random_bytes = random_bytes
        self.action = action
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'}2H\xaa' if boxed else b'') as writer:
            writer.long(self.random_id)
            writer.bytes(self.random_bytes)
            writer.object(
                self.action,
                group_id=0XCD835435
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        random_id_ = reader.long()
        random_bytes_ = reader.bytes()
        action_ = reader.object(
            group_id=0XCD835435
        )

        return cls(
            random_id=random_id_,
            random_bytes=random_bytes_,
            action=action_
        )

class DecryptedMessage23(TLObject, family='TypeDecryptedMessage'):
    _id = 0X204D3878
    _group_id = 0XC3103AAD

    def __init__(
        self,
        ttl: int,
        message: str,
        media: 'TypeDecryptedMessageMedia',
        random_id: int = None
    ):

        self.ttl = ttl
        self.message = message
        self.media = media
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'x8M ' if boxed else b'') as writer:
            writer.long(self.random_id)
            writer.int(self.ttl)
            writer.string(self.message)
            writer.object(
                self.media,
                group_id=0X403DEA17
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        random_id_ = reader.long()
        ttl_ = reader.int()
        message_ = reader.string()
        media_ = reader.object(
            group_id=0X403DEA17
        )

        return cls(
            random_id=random_id_,
            ttl=ttl_,
            message=message_,
            media=media_
        )

class DecryptedMessageService(TLObject, family='TypeDecryptedMessage'):
    _id = 0X73164160
    _group_id = 0XC3103AAD

    def __init__(
        self,
        action: 'TypeDecryptedMessageAction',
        random_id: int = None
    ):

        self.action = action
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'`A\x16s' if boxed else b'') as writer:
            writer.long(self.random_id)
            writer.object(
                self.action,
                group_id=0XCD835435
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        random_id_ = reader.long()
        action_ = reader.object(
            group_id=0XCD835435
        )

        return cls(
            random_id=random_id_,
            action=action_
        )

class DecryptedMessage46(TLObject, family='TypeDecryptedMessage'):
    _id = 0X36B091DE
    _group_id = 0XC3103AAD

    def __init__(
        self,
        ttl: int,
        message: str,
        media: Optional['TypeDecryptedMessageMedia'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        via_bot_name: Optional[str] = None,
        reply_to_random_id: Optional[int] = None,
        random_id: int = None
    ):

        self.ttl = ttl
        self.message = message
        self.media = media
        self.entities = entities
        self.via_bot_name = via_bot_name
        self.reply_to_random_id = reply_to_random_id
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xde\x91\xb06' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.random_id)
                writer.int(self.ttl)
                writer.string(self.message)

                if flags(self.media, 9):
                    writer.object(
                        self.media,
                        group_id=0X403DEA17
                    )

                if flags(self.entities, 7):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.via_bot_name, 11):
                    writer.string(self.via_bot_name)

                if flags(self.reply_to_random_id, 3):
                    writer.long(self.reply_to_random_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        random_id_ = reader.long()
        ttl_ = reader.int()
        message_ = reader.string()
        media_ = (
            reader.object(
                group_id=0X403DEA17
            )
            if flags(9) else None
        )

        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(7) else None
        )

        via_bot_name_ = (
            reader.string()
            if flags(11) else None
        )

        reply_to_random_id_ = (
            reader.long()
            if flags(3) else None
        )

        return cls(
            random_id=random_id_,
            ttl=ttl_,
            message=message_,
            media=media_,
            entities=entities_,
            via_bot_name=via_bot_name_,
            reply_to_random_id=reply_to_random_id_
        )

class DecryptedMessage(TLObject, family='TypeDecryptedMessage'):
    _id = 0X91CC4674
    _group_id = 0XC3103AAD

    def __init__(
        self,
        ttl: int,
        message: str,
        silent: bool = False,
        media: Optional['TypeDecryptedMessageMedia'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        via_bot_name: Optional[str] = None,
        reply_to_random_id: Optional[int] = None,
        grouped_id: Optional[int] = None,
        random_id: int = None
    ):

        self.ttl = ttl
        self.message = message
        self.silent = silent
        self.media = media
        self.entities = entities
        self.via_bot_name = via_bot_name
        self.reply_to_random_id = reply_to_random_id
        self.grouped_id = grouped_id
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'tF\xcc\x91' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 5)
                writer.long(self.random_id)
                writer.int(self.ttl)
                writer.string(self.message)

                if flags(self.media, 9):
                    writer.object(
                        self.media,
                        group_id=0X403DEA17
                    )

                if flags(self.entities, 7):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.via_bot_name, 11):
                    writer.string(self.via_bot_name)

                if flags(self.reply_to_random_id, 3):
                    writer.long(self.reply_to_random_id)

                if flags(self.grouped_id, 17):
                    writer.long(self.grouped_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        random_id_ = reader.long()
        ttl_ = reader.int()
        message_ = reader.string()
        media_ = (
            reader.object(
                group_id=0X403DEA17
            )
            if flags(9) else None
        )

        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(7) else None
        )

        via_bot_name_ = (
            reader.string()
            if flags(11) else None
        )

        reply_to_random_id_ = (
            reader.long()
            if flags(3) else None
        )

        grouped_id_ = (
            reader.long()
            if flags(17) else None
        )

        return cls(
            random_id=random_id_,
            ttl=ttl_,
            message=message_,
            silent=flags(5),
            media=media_,
            entities=entities_,
            via_bot_name=via_bot_name_,
            reply_to_random_id=reply_to_random_id_,
            grouped_id=grouped_id_
        )

TypeDecryptedMessage = Union[
    DecryptedMessage8,
    DecryptedMessageService8,
    DecryptedMessage23,
    DecryptedMessageService,
    DecryptedMessage46,
    DecryptedMessage
]