
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class AutoDownloadSettings(TLObject, family='TypeAutoDownloadSettings'):
    """
    Autodownload settings
    """

    _id = 0XBAA57628
    _group_id = 0X55367DE2

    def __init__(
        self,
        photo_size_max: int,
        video_size_max: int,
        file_size_max: int,
        video_upload_maxbitrate: int,
        small_queue_active_operations_max: int,
        large_queue_active_operations_max: int,
        disabled: bool = False,
        video_preload_large: bool = False,
        audio_preload_next: bool = False,
        phonecalls_less_data: bool = False,
        stories_preload: bool = False
    ):

        """
        Autodownload settings

        Args:
            photo_size_max (int): Maximum size of photos to preload
            video_size_max (int): Maximum size of videos to preload
            file_size_max (int): Maximum size of other files to preload
            video_upload_maxbitrate (int): Maximum suggested bitrate for uploading videos
            small_queue_active_operations_max (int): A limit, specifying the maximum number of files that should be downloaded in parallel from the same DC, for files smaller than 20MB.
            large_queue_active_operations_max (int): A limit, specifying the maximum number of files that should be downloaded in parallel from the same DC, for files bigger than 20MB.
            disabled (bool, optional): Disable automatic media downloads?
            video_preload_large (bool, optional): Whether to preload the first seconds of videos larger than the specified limit
            audio_preload_next (bool, optional): Whether to preload the next audio track when you're listening to music
            phonecalls_less_data (bool, optional): Whether to enable data saving mode in phone calls
            stories_preload (bool, optional): Whether to preload [stories](https://core.telegram.org/api/stories); in particular, the first [documentAttributeVideo](https://core.telegram.org/constructor/documentAttributeVideo). preload_prefix_size bytes of story videos should be preloaded.
        """

        self.photo_size_max = photo_size_max
        self.video_size_max = video_size_max
        self.file_size_max = file_size_max
        self.video_upload_maxbitrate = video_upload_maxbitrate
        self.small_queue_active_operations_max = small_queue_active_operations_max
        self.large_queue_active_operations_max = large_queue_active_operations_max
        self.disabled = disabled
        self.video_preload_large = video_preload_large
        self.audio_preload_next = audio_preload_next
        self.phonecalls_less_data = phonecalls_less_data
        self.stories_preload = stories_preload

    def to_bytes(self, boxed: bool=True):
        with Writer(b'(v\xa5\xba' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.disabled, 0)
                flags(self.video_preload_large, 1)
                flags(self.audio_preload_next, 2)
                flags(self.phonecalls_less_data, 3)
                flags(self.stories_preload, 4)
                writer.int(self.photo_size_max)
                writer.long(self.video_size_max)
                writer.long(self.file_size_max)
                writer.int(self.video_upload_maxbitrate)
                writer.int(self.small_queue_active_operations_max)
                writer.int(self.large_queue_active_operations_max)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        photo_size_max_ = reader.int()
        video_size_max_ = reader.long()
        file_size_max_ = reader.long()
        video_upload_maxbitrate_ = reader.int()
        small_queue_active_operations_max_ = reader.int()
        large_queue_active_operations_max_ = reader.int()

        return cls(
            photo_size_max=photo_size_max_,
            video_size_max=video_size_max_,
            file_size_max=file_size_max_,
            video_upload_maxbitrate=video_upload_maxbitrate_,
            small_queue_active_operations_max=small_queue_active_operations_max_,
            large_queue_active_operations_max=large_queue_active_operations_max_,
            disabled=flags(0),
            video_preload_large=flags(1),
            audio_preload_next=flags(2),
            phonecalls_less_data=flags(3),
            stories_preload=flags(4)
        )

TypeAutoDownloadSettings = AutoDownloadSettings