
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class AvailableEffect(TLObject, family='TypeAvailableEffect'):
    """
    Represents a [message effect](https://core.telegram.org/api/effects).
    """

    _id = 0X93C3E27E
    _group_id = 0X34642D8E

    def __init__(
        self,
        id: int,
        emoticon: str,
        effect_sticker_id: int,
        premium_required: bool = False,
        static_icon_id: Optional[int] = None,
        effect_animation_id: Optional[int] = None
    ):

        """
        Represents a [message effect](https://core.telegram.org/api/effects).

        Args:
            id (int): Unique effect ID.
            emoticon (str): Emoji corresponding to the effect, to be used as icon for the effect if static_icon_id is not set.
            effect_sticker_id (int): Contains the preview [animation (TGS format )](https://core.telegram.org/api/stickers#animated-stickers), used for the effect selection menu.
            premium_required (bool, optional): Whether a [Premium](https://core.telegram.org/api/premium) subscription is required to use this effect.
            static_icon_id (Optional[int], optional): ID of the document containing the static icon (WEBP) of the effect.
            effect_animation_id (Optional[int], optional): If set, contains the actual animated effect [(TGS format )](https://core.telegram.org/api/stickers#animated-stickers). If not set, the animated effect must be set equal to the [premium animated sticker effect](https://core.telegram.org/api/stickers#premium-animated-sticker-effects) associated to the animated sticker specified in effect_sticker_id (always different from the preview animation, fetched thanks to the [videoSize](https://core.telegram.org/constructor/videoSize) of type f as specified [here](https://core.telegram.org/api/stickers#premium-animated-sticker-effects)).
        """

        self.id = id
        self.emoticon = emoticon
        self.effect_sticker_id = effect_sticker_id
        self.premium_required = premium_required
        self.static_icon_id = static_icon_id
        self.effect_animation_id = effect_animation_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'~\xe2\xc3\x93' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.premium_required, 2)
                writer.long(self.id)
                writer.string(self.emoticon)

                if flags(self.static_icon_id, 0):
                    writer.long(self.static_icon_id)
                writer.long(self.effect_sticker_id)

                if flags(self.effect_animation_id, 1):
                    writer.long(self.effect_animation_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        emoticon_ = reader.string()
        static_icon_id_ = (
            reader.long()
            if flags(0) else None
        )

        effect_sticker_id_ = reader.long()
        effect_animation_id_ = (
            reader.long()
            if flags(1) else None
        )

        return cls(
            id=id_,
            emoticon=emoticon_,
            effect_sticker_id=effect_sticker_id_,
            premium_required=flags(2),
            static_icon_id=static_icon_id_,
            effect_animation_id=effect_animation_id_
        )

TypeAvailableEffect = AvailableEffect