
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .message_entity import TypeMessageEntity
    from ...gadgets.byteutils import Reader


class BusinessChatLink(TLObject, family='TypeBusinessChatLink'):
    """
    Contains info about a [business chat deep link](https://core.telegram.org/api/business#business-chat-links) created by the current account.
    """

    _id = 0XB4AE666F
    _group_id = 0XAC1E6918

    def __init__(
        self,
        link: str,
        message: str,
        views: int,
        entities: Optional[List['TypeMessageEntity']] = None,
        title: Optional[str] = None
    ):

        """
        Contains info about a [business chat deep link](https://core.telegram.org/api/business#business-chat-links) created by the current account.

        Args:
            link (str): [Business chat deep link](https://core.telegram.org/api/links#business-chat-links).
            message (str): Message to pre-fill in the message input field.
            views (int): Number of times the link was resolved (clicked/scanned/etc...).
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            title (Optional[str], optional): Human-readable name of the link, to simplify management in the UI (only visible to the creator of the link).
        """

        self.link = link
        self.message = message
        self.views = views
        self.entities = entities
        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'of\xae\xb4' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.link)
                writer.string(self.message)

                if flags(self.entities, 0):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.title, 1):
                    writer.string(self.title)
                writer.int(self.views)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        link_ = reader.string()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(0) else None
        )

        title_ = (
            reader.string()
            if flags(1) else None
        )

        views_ = reader.int()

        return cls(
            link=link_,
            message=message_,
            views=views_,
            entities=entities_,
            title=title_
        )

TypeBusinessChatLink = BusinessChatLink