
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ChannelParticipantsRecent(TLObject, family='TypeChannelParticipantsFilter'):
    """
    Fetch only recent participants
    """

    _id = 0XDE3F3C79
    _group_id = 0X70FFAC0D


    def to_bytes(self, boxed: bool=True):
        return b'y<?\xde' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChannelParticipantsAdmins(TLObject, family='TypeChannelParticipantsFilter'):
    """
    Fetch only admin participants
    """

    _id = 0XB4608969
    _group_id = 0X70FFAC0D


    def to_bytes(self, boxed: bool=True):
        return b'i\x89`\xb4' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChannelParticipantsKicked(TLObject, family='TypeChannelParticipantsFilter'):
    """
    Fetch only kicked participants
    """

    _id = 0XA3B54985
    _group_id = 0X70FFAC0D

    def __init__(
        self,
        q: str
    ):

        """
        Fetch only kicked participants

        Args:
            q (str): Optional filter for searching kicked participants by name (otherwise empty)
        """

        self.q = q

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x85I\xb5\xa3' if boxed else b'') as writer:
            writer.string(self.q)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        q_ = reader.string()

        return cls(
            q=q_
        )

class ChannelParticipantsBots(TLObject, family='TypeChannelParticipantsFilter'):
    """
    Fetch only bot participants
    """

    _id = 0XB0D1865B
    _group_id = 0X70FFAC0D


    def to_bytes(self, boxed: bool=True):
        return b'[\x86\xd1\xb0' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChannelParticipantsBanned(TLObject, family='TypeChannelParticipantsFilter'):
    """
    Fetch only banned participants
    """

    _id = 0X1427A5E1
    _group_id = 0X70FFAC0D

    def __init__(
        self,
        q: str
    ):

        """
        Fetch only banned participants

        Args:
            q (str): Optional filter for searching banned participants by name (otherwise empty)
        """

        self.q = q

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xe1\xa5'\x14" if boxed else b'') as writer:
            writer.string(self.q)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        q_ = reader.string()

        return cls(
            q=q_
        )

class ChannelParticipantsSearch(TLObject, family='TypeChannelParticipantsFilter'):
    """
    Query participants by name
    """

    _id = 0X656AC4B
    _group_id = 0X70FFAC0D

    def __init__(
        self,
        q: str
    ):

        """
        Query participants by name

        Args:
            q (str): Search query
        """

        self.q = q

    def to_bytes(self, boxed: bool=True):
        with Writer(b'K\xacV\x06' if boxed else b'') as writer:
            writer.string(self.q)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        q_ = reader.string()

        return cls(
            q=q_
        )

class ChannelParticipantsContacts(TLObject, family='TypeChannelParticipantsFilter'):
    """
    Fetch only participants that are also contacts
    """

    _id = 0XBB6AE88D
    _group_id = 0X70FFAC0D

    def __init__(
        self,
        q: str
    ):

        """
        Fetch only participants that are also contacts

        Args:
            q (str): Optional search query for searching contact participants by name
        """

        self.q = q

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8d\xe8j\xbb' if boxed else b'') as writer:
            writer.string(self.q)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        q_ = reader.string()

        return cls(
            q=q_
        )

class ChannelParticipantsMentions(TLObject, family='TypeChannelParticipantsFilter'):
    """
    This filter is used when looking for supergroup members to mention. 
    This filter will automatically remove anonymous admins, and return even non-participant users that replied to a specific [thread](https://core.telegram.org/api/threads) through the [comment section](https://core.telegram.org/api/threads#channel-comments) of a channel.
    """

    _id = 0XE04B5CEB
    _group_id = 0X70FFAC0D

    def __init__(
        self,
        q: Optional[str] = None,
        top_msg_id: Optional[int] = None
    ):

        """
        This filter is used when looking for supergroup members to mention. 
        This filter will automatically remove anonymous admins, and return even non-participant users that replied to a specific [thread](https://core.telegram.org/api/threads) through the [comment section](https://core.telegram.org/api/threads#channel-comments) of a channel.

        Args:
            q (Optional[str], optional): Filter by user name or username
            top_msg_id (Optional[int], optional): Look only for users that posted in this [thread](https://core.telegram.org/api/threads)
        """

        self.q = q
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeb\\K\xe0' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.q, 0):
                    writer.string(self.q)

                if flags(self.top_msg_id, 1):
                    writer.int(self.top_msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        q_ = (
            reader.string()
            if flags(0) else None
        )

        top_msg_id_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            q=q_,
            top_msg_id=top_msg_id_
        )

TypeChannelParticipantsFilter = Union[
    ChannelParticipantsRecent,
    ChannelParticipantsAdmins,
    ChannelParticipantsKicked,
    ChannelParticipantsBots,
    ChannelParticipantsBanned,
    ChannelParticipantsSearch,
    ChannelParticipantsContacts,
    ChannelParticipantsMentions
]