
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .reaction import TypeReaction
    from ...gadgets.byteutils import Reader


class ChatReactionsNone(TLObject, family='TypeChatReactions'):
    """
    No reactions are allowed
    """

    _id = 0XEAFC32BC
    _group_id = 0XE0A5CEE3


    def to_bytes(self, boxed: bool=True):
        return b'\xbc2\xfc\xea' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class ChatReactionsAll(TLObject, family='TypeChatReactions'):
    """
    All reactions or all non-custom reactions are allowed
    """

    _id = 0X52928BCA
    _group_id = 0XE0A5CEE3

    def __init__(
        self,
        allow_custom: bool = False
    ):

        """
        All reactions or all non-custom reactions are allowed

        Args:
            allow_custom (bool, optional): Whether to allow custom reactions
        """

        self.allow_custom = allow_custom

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xca\x8b\x92R' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.allow_custom, 0)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            allow_custom=flags(0)
        )

class ChatReactionsSome(TLObject, family='TypeChatReactions'):
    """
    Some reactions are allowed
    """

    _id = 0X661D4037
    _group_id = 0XE0A5CEE3

    def __init__(
        self,
        reactions: List['TypeReaction']
    ):

        """
        Some reactions are allowed

        Args:
            reactions (List['TypeReaction']): Allowed set of reactions: the [reactions_in_chat_max](https://core.telegram.org/api/config#reactions-in-chat-max) configuration field indicates the maximum number of reactions that can be specified in this field.
        """

        self.reactions = reactions

    def to_bytes(self, boxed: bool=True):
        with Writer(b'7@\x1df' if boxed else b'') as writer:
            writer.vector(
                self.reactions,
                lambda value: writer.object(
                    value,
                    group_id=0X19F930D1
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        reactions_ = reader.vector(
            lambda: reader.object(
                group_id=0X19F930D1
            )
        )

        return cls(
            reactions=reactions_
        )

TypeChatReactions = Union[
    ChatReactionsNone,
    ChatReactionsAll,
    ChatReactionsSome
]