
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .reaction import TypeReaction
    from .dc_option import TypeDcOption
    from ...gadgets.byteutils import Reader


class Config(TLObject, family='TypeConfig'):
    """
    Current configuration
    """

    _id = 0XCC1A241E
    _group_id = 0X184F42F1

    def __init__(
        self,
        date: int,
        expires: int,
        test_mode: bool,
        this_dc: int,
        dc_options: List['TypeDcOption'],
        dc_txt_domain_name: str,
        chat_size_max: int,
        megagroup_size_max: int,
        forwarded_count_max: int,
        online_update_period_ms: int,
        offline_blur_timeout_ms: int,
        offline_idle_timeout_ms: int,
        online_cloud_timeout_ms: int,
        notify_cloud_delay_ms: int,
        notify_default_delay_ms: int,
        push_chat_period_ms: int,
        push_chat_limit: int,
        edit_time_limit: int,
        revoke_time_limit: int,
        revoke_pm_time_limit: int,
        rating_e_decay: int,
        stickers_recent_limit: int,
        channels_read_media_period: int,
        call_receive_timeout_ms: int,
        call_ring_timeout_ms: int,
        call_connect_timeout_ms: int,
        call_packet_timeout_ms: int,
        me_url_prefix: str,
        caption_length_max: int,
        message_length_max: int,
        webfile_dc_id: int,
        default_p2p_contacts: bool = False,
        preload_featured_stickers: bool = False,
        revoke_pm_inbox: bool = False,
        blocked_mode: bool = False,
        force_try_ipv6: bool = False,
        tmp_sessions: Optional[int] = None,
        autoupdate_url_prefix: Optional[str] = None,
        gif_search_username: Optional[str] = None,
        venue_search_username: Optional[str] = None,
        img_search_username: Optional[str] = None,
        static_maps_provider: Optional[str] = None,
        suggested_lang_code: Optional[str] = None,
        lang_pack_version: Optional[int] = None,
        base_lang_pack_version: Optional[int] = None,
        reactions_default: Optional['TypeReaction'] = None,
        autologin_token: Optional[str] = None
    ):

        """
        Current configuration

        Args:
            date (int): Current date at the server
            expires (int): Expiration date of this config: when it expires it'll have to be refetched using [help.getConfig](https://core.telegram.org/method/help.getConfig)
            test_mode (bool): Whether we're connected to the test DCs
            this_dc (int): ID of the DC that returned the reply
            dc_options (List['TypeDcOption']): DC IP list
            dc_txt_domain_name (str): Domain name for fetching encrypted DC list from DNS TXT record
            chat_size_max (int): Maximum member count for normal [groups](https://core.telegram.org/api/channel)
            megagroup_size_max (int): Maximum member count for [supergroups](https://core.telegram.org/api/channel)
            forwarded_count_max (int): Maximum number of messages that can be forwarded at once using [messages.forwardMessages](https://core.telegram.org/method/messages.forwardMessages).
            online_update_period_ms (int): The client should [update its online status](https://core.telegram.org/method/account.updateStatus) every N milliseconds
            offline_blur_timeout_ms (int): Delay before offline status needs to be sent to the server
            offline_idle_timeout_ms (int): Time without any user activity after which it should be treated offline
            online_cloud_timeout_ms (int): If we are offline, but were online from some other client in last online_cloud_timeout_ms milliseconds after we had gone offline, then delay offline notification for notify_cloud_delay_ms milliseconds.
            notify_cloud_delay_ms (int): If we are offline, but online from some other client then delay sending the offline notification for notify_cloud_delay_ms milliseconds.
            notify_default_delay_ms (int): If some other client is online, then delay notification for notification_default_delay_ms milliseconds
            push_chat_period_ms (int): Not for client use
            push_chat_limit (int): Not for client use
            edit_time_limit (int): Only messages with age smaller than the one specified can be edited
            revoke_time_limit (int): Only channel/supergroup messages with age smaller than the specified can be deleted
            revoke_pm_time_limit (int): Only private messages with age smaller than the specified can be deleted
            rating_e_decay (int): Exponential decay rate for computing [top peer rating](https://core.telegram.org/api/top-rating)
            stickers_recent_limit (int): Maximum number of recent stickers
            channels_read_media_period (int): Indicates that round videos (video notes) and voice messages sent in channels and older than the specified period must be marked as read
            call_receive_timeout_ms (int): Maximum allowed outgoing ring time in VoIP calls: if the user we're calling doesn't reply within the specified time (in milliseconds), we should hang up the call
            call_ring_timeout_ms (int): Maximum allowed incoming ring time in VoIP calls: if the current user doesn't reply within the specified time (in milliseconds), the call will be automatically refused
            call_connect_timeout_ms (int): VoIP connection timeout: if the instance of libtgvoip on the other side of the call doesn't connect to our instance of libtgvoip within the specified time (in milliseconds), the call must be aborted
            call_packet_timeout_ms (int): If during a VoIP call a packet isn't received for the specified period of time, the call must be aborted
            me_url_prefix (str): The domain to use to parse [deep links](https://core.telegram.org/api/links).
            caption_length_max (int): Maximum length of caption (length in utf8 codepoints)
            message_length_max (int): Maximum length of messages (length in utf8 codepoints)
            webfile_dc_id (int): DC ID to use to download [webfiles](https://core.telegram.org/api/files#downloading-webfiles)
            default_p2p_contacts (bool, optional): Whether the client should use P2P by default for phone calls with contacts
            preload_featured_stickers (bool, optional): Whether the client should preload featured stickers
            revoke_pm_inbox (bool, optional): Whether incoming private messages can be deleted for both participants
            blocked_mode (bool, optional): Indicates that telegram is probably censored by governments/ISPs in the current region
            force_try_ipv6 (bool, optional): Whether to forcefully connect using IPv6 [dcOptions](https://core.telegram.org/type/DcOption), even if the client knows that IPv4 is available.
            tmp_sessions (Optional[int], optional): Temporary [passport](https://core.telegram.org/passport) sessions
            autoupdate_url_prefix (Optional[str], optional): URL to use to auto-update the current app
            gif_search_username (Optional[str], optional): Username of the bot to use to search for GIFs
            venue_search_username (Optional[str], optional): Username of the bot to use to search for venues
            img_search_username (Optional[str], optional): Username of the bot to use for image search
            static_maps_provider (Optional[str], optional): ID of the map provider to use for venues
            suggested_lang_code (Optional[str], optional): Suggested language code
            lang_pack_version (Optional[int], optional): Language pack version
            base_lang_pack_version (Optional[int], optional): Basic language pack version
            reactions_default (Optional['TypeReaction'], optional): Default [message reaction](https://core.telegram.org/api/reactions)
            autologin_token (Optional[str], optional): Autologin token, [click here for more info on URL authorization](https://core.telegram.org/api/url-authorization#link-url-authorization).
        """

        self.date = date
        self.expires = expires
        self.test_mode = test_mode
        self.this_dc = this_dc
        self.dc_options = dc_options
        self.dc_txt_domain_name = dc_txt_domain_name
        self.chat_size_max = chat_size_max
        self.megagroup_size_max = megagroup_size_max
        self.forwarded_count_max = forwarded_count_max
        self.online_update_period_ms = online_update_period_ms
        self.offline_blur_timeout_ms = offline_blur_timeout_ms
        self.offline_idle_timeout_ms = offline_idle_timeout_ms
        self.online_cloud_timeout_ms = online_cloud_timeout_ms
        self.notify_cloud_delay_ms = notify_cloud_delay_ms
        self.notify_default_delay_ms = notify_default_delay_ms
        self.push_chat_period_ms = push_chat_period_ms
        self.push_chat_limit = push_chat_limit
        self.edit_time_limit = edit_time_limit
        self.revoke_time_limit = revoke_time_limit
        self.revoke_pm_time_limit = revoke_pm_time_limit
        self.rating_e_decay = rating_e_decay
        self.stickers_recent_limit = stickers_recent_limit
        self.channels_read_media_period = channels_read_media_period
        self.call_receive_timeout_ms = call_receive_timeout_ms
        self.call_ring_timeout_ms = call_ring_timeout_ms
        self.call_connect_timeout_ms = call_connect_timeout_ms
        self.call_packet_timeout_ms = call_packet_timeout_ms
        self.me_url_prefix = me_url_prefix
        self.caption_length_max = caption_length_max
        self.message_length_max = message_length_max
        self.webfile_dc_id = webfile_dc_id
        self.default_p2p_contacts = default_p2p_contacts
        self.preload_featured_stickers = preload_featured_stickers
        self.revoke_pm_inbox = revoke_pm_inbox
        self.blocked_mode = blocked_mode
        self.force_try_ipv6 = force_try_ipv6
        self.tmp_sessions = tmp_sessions
        self.autoupdate_url_prefix = autoupdate_url_prefix
        self.gif_search_username = gif_search_username
        self.venue_search_username = venue_search_username
        self.img_search_username = img_search_username
        self.static_maps_provider = static_maps_provider
        self.suggested_lang_code = suggested_lang_code
        self.lang_pack_version = lang_pack_version
        self.base_lang_pack_version = base_lang_pack_version
        self.reactions_default = reactions_default
        self.autologin_token = autologin_token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1e$\x1a\xcc' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.default_p2p_contacts, 3)
                flags(self.preload_featured_stickers, 4)
                flags(self.revoke_pm_inbox, 6)
                flags(self.blocked_mode, 8)
                flags(self.force_try_ipv6, 14)
                writer.int(self.date)
                writer.int(self.expires)
                writer.object(
                    self.test_mode,
                    group_id=0X43B904E1
                )
                writer.int(self.this_dc)
                writer.vector(
                    self.dc_options,
                    lambda value: writer.object(
                        value,
                        group_id=0XDA1BB453
                    )
                )
                writer.string(self.dc_txt_domain_name)
                writer.int(self.chat_size_max)
                writer.int(self.megagroup_size_max)
                writer.int(self.forwarded_count_max)
                writer.int(self.online_update_period_ms)
                writer.int(self.offline_blur_timeout_ms)
                writer.int(self.offline_idle_timeout_ms)
                writer.int(self.online_cloud_timeout_ms)
                writer.int(self.notify_cloud_delay_ms)
                writer.int(self.notify_default_delay_ms)
                writer.int(self.push_chat_period_ms)
                writer.int(self.push_chat_limit)
                writer.int(self.edit_time_limit)
                writer.int(self.revoke_time_limit)
                writer.int(self.revoke_pm_time_limit)
                writer.int(self.rating_e_decay)
                writer.int(self.stickers_recent_limit)
                writer.int(self.channels_read_media_period)

                if flags(self.tmp_sessions, 0):
                    writer.int(self.tmp_sessions)
                writer.int(self.call_receive_timeout_ms)
                writer.int(self.call_ring_timeout_ms)
                writer.int(self.call_connect_timeout_ms)
                writer.int(self.call_packet_timeout_ms)
                writer.string(self.me_url_prefix)

                if flags(self.autoupdate_url_prefix, 7):
                    writer.string(self.autoupdate_url_prefix)

                if flags(self.gif_search_username, 9):
                    writer.string(self.gif_search_username)

                if flags(self.venue_search_username, 10):
                    writer.string(self.venue_search_username)

                if flags(self.img_search_username, 11):
                    writer.string(self.img_search_username)

                if flags(self.static_maps_provider, 12):
                    writer.string(self.static_maps_provider)
                writer.int(self.caption_length_max)
                writer.int(self.message_length_max)
                writer.int(self.webfile_dc_id)

                if flags(self.suggested_lang_code, 2):
                    writer.string(self.suggested_lang_code)

                if flags(self.lang_pack_version, 2):
                    writer.int(self.lang_pack_version)

                if flags(self.base_lang_pack_version, 2):
                    writer.int(self.base_lang_pack_version)

                if flags(self.reactions_default, 15):
                    writer.object(
                        self.reactions_default,
                        group_id=0X19F930D1
                    )

                if flags(self.autologin_token, 16):
                    writer.string(self.autologin_token)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        date_ = reader.int()
        expires_ = reader.int()
        test_mode_ = reader.object(
            group_id=0X43B904E1
        )

        this_dc_ = reader.int()
        dc_options_ = reader.vector(
            lambda: reader.object(
                group_id=0XDA1BB453
            )
        )

        dc_txt_domain_name_ = reader.string()
        chat_size_max_ = reader.int()
        megagroup_size_max_ = reader.int()
        forwarded_count_max_ = reader.int()
        online_update_period_ms_ = reader.int()
        offline_blur_timeout_ms_ = reader.int()
        offline_idle_timeout_ms_ = reader.int()
        online_cloud_timeout_ms_ = reader.int()
        notify_cloud_delay_ms_ = reader.int()
        notify_default_delay_ms_ = reader.int()
        push_chat_period_ms_ = reader.int()
        push_chat_limit_ = reader.int()
        edit_time_limit_ = reader.int()
        revoke_time_limit_ = reader.int()
        revoke_pm_time_limit_ = reader.int()
        rating_e_decay_ = reader.int()
        stickers_recent_limit_ = reader.int()
        channels_read_media_period_ = reader.int()
        tmp_sessions_ = (
            reader.int()
            if flags(0) else None
        )

        call_receive_timeout_ms_ = reader.int()
        call_ring_timeout_ms_ = reader.int()
        call_connect_timeout_ms_ = reader.int()
        call_packet_timeout_ms_ = reader.int()
        me_url_prefix_ = reader.string()
        autoupdate_url_prefix_ = (
            reader.string()
            if flags(7) else None
        )

        gif_search_username_ = (
            reader.string()
            if flags(9) else None
        )

        venue_search_username_ = (
            reader.string()
            if flags(10) else None
        )

        img_search_username_ = (
            reader.string()
            if flags(11) else None
        )

        static_maps_provider_ = (
            reader.string()
            if flags(12) else None
        )

        caption_length_max_ = reader.int()
        message_length_max_ = reader.int()
        webfile_dc_id_ = reader.int()
        suggested_lang_code_ = (
            reader.string()
            if flags(2) else None
        )

        lang_pack_version_ = (
            reader.int()
            if flags(2) else None
        )

        base_lang_pack_version_ = (
            reader.int()
            if flags(2) else None
        )

        reactions_default_ = (
            reader.object(
                group_id=0X19F930D1
            )
            if flags(15) else None
        )

        autologin_token_ = (
            reader.string()
            if flags(16) else None
        )

        return cls(
            date=date_,
            expires=expires_,
            test_mode=test_mode_,
            this_dc=this_dc_,
            dc_options=dc_options_,
            dc_txt_domain_name=dc_txt_domain_name_,
            chat_size_max=chat_size_max_,
            megagroup_size_max=megagroup_size_max_,
            forwarded_count_max=forwarded_count_max_,
            online_update_period_ms=online_update_period_ms_,
            offline_blur_timeout_ms=offline_blur_timeout_ms_,
            offline_idle_timeout_ms=offline_idle_timeout_ms_,
            online_cloud_timeout_ms=online_cloud_timeout_ms_,
            notify_cloud_delay_ms=notify_cloud_delay_ms_,
            notify_default_delay_ms=notify_default_delay_ms_,
            push_chat_period_ms=push_chat_period_ms_,
            push_chat_limit=push_chat_limit_,
            edit_time_limit=edit_time_limit_,
            revoke_time_limit=revoke_time_limit_,
            revoke_pm_time_limit=revoke_pm_time_limit_,
            rating_e_decay=rating_e_decay_,
            stickers_recent_limit=stickers_recent_limit_,
            channels_read_media_period=channels_read_media_period_,
            call_receive_timeout_ms=call_receive_timeout_ms_,
            call_ring_timeout_ms=call_ring_timeout_ms_,
            call_connect_timeout_ms=call_connect_timeout_ms_,
            call_packet_timeout_ms=call_packet_timeout_ms_,
            me_url_prefix=me_url_prefix_,
            caption_length_max=caption_length_max_,
            message_length_max=message_length_max_,
            webfile_dc_id=webfile_dc_id_,
            default_p2p_contacts=flags(3),
            preload_featured_stickers=flags(4),
            revoke_pm_inbox=flags(6),
            blocked_mode=flags(8),
            force_try_ipv6=flags(14),
            tmp_sessions=tmp_sessions_,
            autoupdate_url_prefix=autoupdate_url_prefix_,
            gif_search_username=gif_search_username_,
            venue_search_username=venue_search_username_,
            img_search_username=img_search_username_,
            static_maps_provider=static_maps_provider_,
            suggested_lang_code=suggested_lang_code_,
            lang_pack_version=lang_pack_version_,
            base_lang_pack_version=base_lang_pack_version_,
            reactions_default=reactions_default_,
            autologin_token=autologin_token_
        )

TypeConfig = Config