
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class Contact(TLObject, family='TypeContact'):
    """
    A contact of the current user that is registered in the system.
    """

    _id = 0X145ADE0B
    _group_id = 0XDFA7DCC8

    def __init__(
        self,
        user_id: int,
        mutual: bool
    ):

        """
        A contact of the current user that is registered in the system.

        Args:
            user_id (int): User identifier
            mutual (bool): Current user is in the user's contact list
        """

        self.user_id = user_id
        self.mutual = mutual

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0b\xdeZ\x14' if boxed else b'') as writer:
            writer.long(self.user_id)
            writer.object(
                self.mutual,
                group_id=0X43B904E1
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        user_id_ = reader.long()
        mutual_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            user_id=user_id_,
            mutual=mutual_
        )

TypeContact = Contact