
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..peer import TypePeer
    from ..chat import TypeChat
    from ..user import TypeUser
    from ....gadgets.byteutils import Reader


class Found(TLObject, family='TypeContactsFound'):
    """
    Users found by name substring and auxiliary data.
    """

    _id = 0XB3134D9D
    _group_id = 0X8CCE8093

    def __init__(
        self,
        my_results: List['TypePeer'],
        results: List['TypePeer'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Users found by name substring and auxiliary data.

        Args:
            my_results (List['TypePeer']): Personalized results
            results (List['TypePeer']): List of found user identifiers
            chats (List['TypeChat']): Found chats
            users (List['TypeUser']): List of users
        """

        self.my_results = my_results
        self.results = results
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9dM\x13\xb3' if boxed else b'') as writer:
            writer.vector(
                self.my_results,
                lambda value: writer.object(
                    value,
                    group_id=0XB4DECBCA
                )
            )
            writer.vector(
                self.results,
                lambda value: writer.object(
                    value,
                    group_id=0XB4DECBCA
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        my_results_ = reader.vector(
            lambda: reader.object(
                group_id=0XB4DECBCA
            )
        )

        results_ = reader.vector(
            lambda: reader.object(
                group_id=0XB4DECBCA
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            my_results=my_results_,
            results=results_,
            chats=chats_,
            users=users_
        )

TypeContactsFound = Found