
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..popular_contact import TypePopularContact
    from ..imported_contact import TypeImportedContact
    from ....gadgets.byteutils import Reader


class ImportedContacts(TLObject, family='TypeContactsImportedContacts'):
    """
    Info on successfully imported contacts.
    """

    _id = 0X77D01C3B
    _group_id = 0XF234D809

    def __init__(
        self,
        imported: List['TypeImportedContact'],
        popular_invites: List['TypePopularContact'],
        retry_contacts: List[int],
        users: List['TypeUser']
    ):

        """
        Info on successfully imported contacts.

        Args:
            imported (List['TypeImportedContact']): List of successfully imported contacts
            popular_invites (List['TypePopularContact']): Popular contacts
            retry_contacts (List[int]): List of contact ids that could not be imported due to system limitation and will need to be imported at a later date.
            users (List['TypeUser']): List of users
        """

        self.imported = imported
        self.popular_invites = popular_invites
        self.retry_contacts = retry_contacts
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b';\x1c\xd0w' if boxed else b'') as writer:
            writer.vector(
                self.imported,
                lambda value: writer.object(
                    value,
                    group_id=0X197BB9D5
                )
            )
            writer.vector(
                self.popular_invites,
                lambda value: writer.object(
                    value,
                    group_id=0X86F26A71
                )
            )
            writer.vector(
                self.retry_contacts,
                writer.long
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        imported_ = reader.vector(
            lambda: reader.object(
                group_id=0X197BB9D5
            )
        )

        popular_invites_ = reader.vector(
            lambda: reader.object(
                group_id=0X86F26A71
            )
        )

        retry_contacts_ = reader.vector(
            reader.long
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            imported=imported_,
            popular_invites=popular_invites_,
            retry_contacts=retry_contacts_,
            users=users_
        )

TypeContactsImportedContacts = ImportedContacts