
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .folder import TypeFolder
    from .draft_message import TypeDraftMessage
    from ...gadgets.byteutils import Reader
    from .peer_notify_settings import TypePeerNotifySettings


class Dialog(TLObject, family='TypeDialog'):
    """
    Chat
    """

    _id = 0XD58A08C6
    _group_id = 0X89A4B5EF

    def __init__(
        self,
        peer: 'TypePeer',
        top_message: int,
        read_inbox_max_id: int,
        read_outbox_max_id: int,
        unread_count: int,
        unread_mentions_count: int,
        unread_reactions_count: int,
        notify_settings: 'TypePeerNotifySettings',
        pinned: bool = False,
        unread_mark: bool = False,
        view_forum_as_messages: bool = False,
        pts: Optional[int] = None,
        draft: Optional['TypeDraftMessage'] = None,
        folder_id: Optional[int] = None,
        ttl_period: Optional[int] = None
    ):

        """
        Chat

        Args:
            peer ('TypePeer'): The chat
            top_message (int): The latest message ID
            read_inbox_max_id (int): Position up to which all incoming messages are read.
            read_outbox_max_id (int): Position up to which all outgoing messages are read.
            unread_count (int): Number of unread messages
            unread_mentions_count (int): Number of [unread mentions](https://core.telegram.org/api/mentions)
            unread_reactions_count (int): Number of unread reactions to messages you sent
            notify_settings ('TypePeerNotifySettings'): Notification settings
            pinned (bool, optional): Is the dialog pinned
            unread_mark (bool, optional): Whether the chat was manually marked as unread
            view_forum_as_messages (bool, optional): Users may also choose to display messages from all topics of a [forum](https://core.telegram.org/api/forum) as if they were sent to a normal group, using a "View as messages" setting in the local client.  This setting only affects the current account, and is synced to other logged in sessions using the [channels.toggleViewForumAsMessages](https://core.telegram.org/method/channels.toggleViewForumAsMessages) method; invoking this method will update the value of this flag.
            pts (Optional[int], optional): [PTS](https://core.telegram.org/api/updates)
            draft (Optional['TypeDraftMessage'], optional): Message [draft](https://core.telegram.org/api/drafts)
            folder_id (Optional[int], optional): [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
            ttl_period (Optional[int], optional): Time-to-live of all messages sent in this dialog
        """

        self.peer = peer
        self.top_message = top_message
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.unread_mentions_count = unread_mentions_count
        self.unread_reactions_count = unread_reactions_count
        self.notify_settings = notify_settings
        self.pinned = pinned
        self.unread_mark = unread_mark
        self.view_forum_as_messages = view_forum_as_messages
        self.pts = pts
        self.draft = draft
        self.folder_id = folder_id
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc6\x08\x8a\xd5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 2)
                flags(self.unread_mark, 3)
                flags(self.view_forum_as_messages, 6)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.top_message)
                writer.int(self.read_inbox_max_id)
                writer.int(self.read_outbox_max_id)
                writer.int(self.unread_count)
                writer.int(self.unread_mentions_count)
                writer.int(self.unread_reactions_count)
                writer.object(
                    self.notify_settings,
                    group_id=0X372BF8CC
                )

                if flags(self.pts, 0):
                    writer.int(self.pts)

                if flags(self.draft, 1):
                    writer.object(
                        self.draft,
                        group_id=0X314F6157
                    )

                if flags(self.folder_id, 4):
                    writer.int(self.folder_id)

                if flags(self.ttl_period, 5):
                    writer.int(self.ttl_period)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        top_message_ = reader.int()
        read_inbox_max_id_ = reader.int()
        read_outbox_max_id_ = reader.int()
        unread_count_ = reader.int()
        unread_mentions_count_ = reader.int()
        unread_reactions_count_ = reader.int()
        notify_settings_ = reader.object(
            group_id=0X372BF8CC
        )

        pts_ = (
            reader.int()
            if flags(0) else None
        )

        draft_ = (
            reader.object(
                group_id=0X314F6157
            )
            if flags(1) else None
        )

        folder_id_ = (
            reader.int()
            if flags(4) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(5) else None
        )

        return cls(
            peer=peer_,
            top_message=top_message_,
            read_inbox_max_id=read_inbox_max_id_,
            read_outbox_max_id=read_outbox_max_id_,
            unread_count=unread_count_,
            unread_mentions_count=unread_mentions_count_,
            unread_reactions_count=unread_reactions_count_,
            notify_settings=notify_settings_,
            pinned=flags(2),
            unread_mark=flags(3),
            view_forum_as_messages=flags(6),
            pts=pts_,
            draft=draft_,
            folder_id=folder_id_,
            ttl_period=ttl_period_
        )

class DialogFolder(TLObject, family='TypeDialog'):
    """
    Dialog in folder
    """

    _id = 0X71BD134C
    _group_id = 0X89A4B5EF

    def __init__(
        self,
        folder: 'TypeFolder',
        peer: 'TypePeer',
        top_message: int,
        unread_muted_peers_count: int,
        unread_unmuted_peers_count: int,
        unread_muted_messages_count: int,
        unread_unmuted_messages_count: int,
        pinned: bool = False
    ):

        """
        Dialog in folder

        Args:
            folder ('TypeFolder'): The folder
            peer ('TypePeer'): Peer in folder
            top_message (int): Latest message ID of dialog
            unread_muted_peers_count (int): Number of unread muted peers in folder
            unread_unmuted_peers_count (int): Number of unread unmuted peers in folder
            unread_muted_messages_count (int): Number of unread messages from muted peers in folder
            unread_unmuted_messages_count (int): Number of unread messages from unmuted peers in folder
            pinned (bool, optional): Is this folder pinned
        """

        self.folder = folder
        self.peer = peer
        self.top_message = top_message
        self.unread_muted_peers_count = unread_muted_peers_count
        self.unread_unmuted_peers_count = unread_unmuted_peers_count
        self.unread_muted_messages_count = unread_muted_messages_count
        self.unread_unmuted_messages_count = unread_unmuted_messages_count
        self.pinned = pinned

    def to_bytes(self, boxed: bool=True):
        with Writer(b'L\x13\xbdq' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 2)
                writer.object(
                    self.folder,
                    group_id=0X20676440
                )
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.top_message)
                writer.int(self.unread_muted_peers_count)
                writer.int(self.unread_unmuted_peers_count)
                writer.int(self.unread_muted_messages_count)
                writer.int(self.unread_unmuted_messages_count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        folder_ = reader.object(
            group_id=0X20676440
        )

        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        top_message_ = reader.int()
        unread_muted_peers_count_ = reader.int()
        unread_unmuted_peers_count_ = reader.int()
        unread_muted_messages_count_ = reader.int()
        unread_unmuted_messages_count_ = reader.int()

        return cls(
            folder=folder_,
            peer=peer_,
            top_message=top_message_,
            unread_muted_peers_count=unread_muted_peers_count_,
            unread_unmuted_peers_count=unread_unmuted_peers_count_,
            unread_muted_messages_count=unread_muted_messages_count_,
            unread_unmuted_messages_count=unread_unmuted_messages_count_,
            pinned=flags(2)
        )

TypeDialog = Union[
    Dialog,
    DialogFolder
]