
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_peer import TypeInputPeer
    from .text_with_entities import TypeTextWithEntities
    from ...gadgets.byteutils import Reader


class DialogFilter(TLObject, family='TypeDialogFilter'):
    """
    Dialog filter AKA [folder](https://core.telegram.org/api/folders)
    """

    _id = 0XAA472651
    _group_id = 0X6BB0DA45

    def __init__(
        self,
        id: int,
        title: 'TypeTextWithEntities',
        pinned_peers: List['TypeInputPeer'],
        include_peers: List['TypeInputPeer'],
        exclude_peers: List['TypeInputPeer'],
        contacts: bool = False,
        non_contacts: bool = False,
        groups: bool = False,
        broadcasts: bool = False,
        bots: bool = False,
        exclude_muted: bool = False,
        exclude_read: bool = False,
        exclude_archived: bool = False,
        title_noanimate: bool = False,
        emoticon: Optional[str] = None,
        color: Optional[int] = None
    ):

        """
        Dialog filter AKA [folder](https://core.telegram.org/api/folders)

        Args:
            id (int): [Folder](https://core.telegram.org/api/folders) ID
            title ('TypeTextWithEntities'): [Folder](https://core.telegram.org/api/folders) name (max 12 UTF-8 chars)
            pinned_peers (List['TypeInputPeer']): Pinned chats, [folders](https://core.telegram.org/api/folders) can have unlimited pinned chats
            include_peers (List['TypeInputPeer']): Include the following chats in this [folder](https://core.telegram.org/api/folders)
            exclude_peers (List['TypeInputPeer']): Exclude the following chats from this [folder](https://core.telegram.org/api/folders)
            contacts (bool, optional): Whether to include all contacts in this [folder](https://core.telegram.org/api/folders)
            non_contacts (bool, optional): Whether to include all non-contacts in this [folder](https://core.telegram.org/api/folders)
            groups (bool, optional): Whether to include all groups in this [folder](https://core.telegram.org/api/folders)
            broadcasts (bool, optional): Whether to include all channels in this [folder](https://core.telegram.org/api/folders)
            bots (bool, optional): Whether to include all bots in this [folder](https://core.telegram.org/api/folders)
            exclude_muted (bool, optional): Whether to exclude muted chats from this [folder](https://core.telegram.org/api/folders)
            exclude_read (bool, optional): Whether to exclude read chats from this [folder](https://core.telegram.org/api/folders)
            exclude_archived (bool, optional): Whether to exclude archived chats from this [folder](https://core.telegram.org/api/folders)
            title_noanimate (bool, optional): ...
            emoticon (Optional[str], optional): Emoji to use as icon for the folder.
            color (Optional[int], optional): A color ID for the [folder tag associated to this folder, see here](https://core.telegram.org/api/folders#folder-tags) for more info.
        """

        self.id = id
        self.title = title
        self.pinned_peers = pinned_peers
        self.include_peers = include_peers
        self.exclude_peers = exclude_peers
        self.contacts = contacts
        self.non_contacts = non_contacts
        self.groups = groups
        self.broadcasts = broadcasts
        self.bots = bots
        self.exclude_muted = exclude_muted
        self.exclude_read = exclude_read
        self.exclude_archived = exclude_archived
        self.title_noanimate = title_noanimate
        self.emoticon = emoticon
        self.color = color

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Q&G\xaa' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.contacts, 0)
                flags(self.non_contacts, 1)
                flags(self.groups, 2)
                flags(self.broadcasts, 3)
                flags(self.bots, 4)
                flags(self.exclude_muted, 11)
                flags(self.exclude_read, 12)
                flags(self.exclude_archived, 13)
                flags(self.title_noanimate, 28)
                writer.int(self.id)
                writer.object(
                    self.title,
                    group_id=0X5D96896
                )

                if flags(self.emoticon, 25):
                    writer.string(self.emoticon)

                if flags(self.color, 27):
                    writer.int(self.color)
                writer.vector(
                    self.pinned_peers,
                    lambda value: writer.object(
                        value,
                        group_id=0X995DB9DF
                    )
                )
                writer.vector(
                    self.include_peers,
                    lambda value: writer.object(
                        value,
                        group_id=0X995DB9DF
                    )
                )
                writer.vector(
                    self.exclude_peers,
                    lambda value: writer.object(
                        value,
                        group_id=0X995DB9DF
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        title_ = reader.object(
            group_id=0X5D96896
        )

        emoticon_ = (
            reader.string()
            if flags(25) else None
        )

        color_ = (
            reader.int()
            if flags(27) else None
        )

        pinned_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0X995DB9DF
            )
        )

        include_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0X995DB9DF
            )
        )

        exclude_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0X995DB9DF
            )
        )

        return cls(
            id=id_,
            title=title_,
            pinned_peers=pinned_peers_,
            include_peers=include_peers_,
            exclude_peers=exclude_peers_,
            contacts=flags(0),
            non_contacts=flags(1),
            groups=flags(2),
            broadcasts=flags(3),
            bots=flags(4),
            exclude_muted=flags(11),
            exclude_read=flags(12),
            exclude_archived=flags(13),
            title_noanimate=flags(28),
            emoticon=emoticon_,
            color=color_
        )

class DialogFilterDefault(TLObject, family='TypeDialogFilter'):
    """
    Used only when reordering folders to indicate the default (all chats) folder.
    """

    _id = 0X363293AE
    _group_id = 0X6BB0DA45


    def to_bytes(self, boxed: bool=True):
        return b'\xae\x9326' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class DialogFilterChatlist(TLObject, family='TypeDialogFilter'):
    """
    A folder imported using a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).
    """

    _id = 0X96537BD7
    _group_id = 0X6BB0DA45

    def __init__(
        self,
        id: int,
        title: 'TypeTextWithEntities',
        pinned_peers: List['TypeInputPeer'],
        include_peers: List['TypeInputPeer'],
        has_my_invites: bool = False,
        title_noanimate: bool = False,
        emoticon: Optional[str] = None,
        color: Optional[int] = None
    ):

        """
        A folder imported using a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).

        Args:
            id (int): ID of the folder
            title ('TypeTextWithEntities'): Name of the folder (max 12 UTF-8 chars)
            pinned_peers (List['TypeInputPeer']): Pinned chats, [folders](https://core.telegram.org/api/folders) can have unlimited pinned chats
            include_peers (List['TypeInputPeer']): Chats to include in the folder
            has_my_invites (bool, optional): Whether the current user has created some [chat folder deep links](https://core.telegram.org/api/links#chat-folder-links) to share the folder as well.
            title_noanimate (bool, optional): ...
            emoticon (Optional[str], optional): Emoji to use as icon for the folder.
            color (Optional[int], optional): A color ID for the [folder tag associated to this folder, see here](https://core.telegram.org/api/folders#folder-tags) for more info.
        """

        self.id = id
        self.title = title
        self.pinned_peers = pinned_peers
        self.include_peers = include_peers
        self.has_my_invites = has_my_invites
        self.title_noanimate = title_noanimate
        self.emoticon = emoticon
        self.color = color

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd7{S\x96' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_my_invites, 26)
                flags(self.title_noanimate, 28)
                writer.int(self.id)
                writer.object(
                    self.title,
                    group_id=0X5D96896
                )

                if flags(self.emoticon, 25):
                    writer.string(self.emoticon)

                if flags(self.color, 27):
                    writer.int(self.color)
                writer.vector(
                    self.pinned_peers,
                    lambda value: writer.object(
                        value,
                        group_id=0X995DB9DF
                    )
                )
                writer.vector(
                    self.include_peers,
                    lambda value: writer.object(
                        value,
                        group_id=0X995DB9DF
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        title_ = reader.object(
            group_id=0X5D96896
        )

        emoticon_ = (
            reader.string()
            if flags(25) else None
        )

        color_ = (
            reader.int()
            if flags(27) else None
        )

        pinned_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0X995DB9DF
            )
        )

        include_peers_ = reader.vector(
            lambda: reader.object(
                group_id=0X995DB9DF
            )
        )

        return cls(
            id=id_,
            title=title_,
            pinned_peers=pinned_peers_,
            include_peers=include_peers_,
            has_my_invites=flags(26),
            title_noanimate=flags(28),
            emoticon=emoticon_,
            color=color_
        )

TypeDialogFilter = Union[
    DialogFilter,
    DialogFilterDefault,
    DialogFilterChatlist
]