
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .stars_subscription_pricing import TypeStarsSubscriptionPricing


class ChatInviteExported(TLObject, family='TypeExportedChatInvite'):
    """
    Exported chat invite
    """

    _id = 0XA22CBD96
    _group_id = 0X4C7FB2E0

    def __init__(
        self,
        link: str,
        admin_id: int,
        date: int,
        revoked: bool = False,
        permanent: bool = False,
        request_needed: bool = False,
        start_date: Optional[int] = None,
        expire_date: Optional[int] = None,
        usage_limit: Optional[int] = None,
        usage: Optional[int] = None,
        requested: Optional[int] = None,
        subscription_expired: Optional[int] = None,
        title: Optional[str] = None,
        subscription_pricing: Optional['TypeStarsSubscriptionPricing'] = None
    ):

        """
        Exported chat invite

        Args:
            link (str): Chat invitation link
            admin_id (int): ID of the admin that created this chat invite
            date (int): When was this chat invite created
            revoked (bool, optional): Whether this chat invite was revoked
            permanent (bool, optional): Whether this chat invite has no expiration
            request_needed (bool, optional): Whether users importing this invite link will have to be approved to join the channel or group
            start_date (Optional[int], optional): When was this chat invite last modified
            expire_date (Optional[int], optional): When does this chat invite expire
            usage_limit (Optional[int], optional): Maximum number of users that can join using this link
            usage (Optional[int], optional): How many users joined using this link
            requested (Optional[int], optional): Number of users that have already used this link to join
            subscription_expired (Optional[int], optional): For [Telegram Star subscriptions](https://core.telegram.org/api/stars#star-subscriptions), contains the number of chat members which have already joined the chat using the link, but have already left due to expiration of their subscription.
            title (Optional[str], optional): Custom description for the invite link, visible only to admins
            subscription_pricing (Optional['TypeStarsSubscriptionPricing'], optional): For [Telegram Star subscriptions](https://core.telegram.org/api/stars#star-subscriptions), contains the pricing of the subscription the user must activate to join the private channel.
        """

        self.link = link
        self.admin_id = admin_id
        self.date = date
        self.revoked = revoked
        self.permanent = permanent
        self.request_needed = request_needed
        self.start_date = start_date
        self.expire_date = expire_date
        self.usage_limit = usage_limit
        self.usage = usage
        self.requested = requested
        self.subscription_expired = subscription_expired
        self.title = title
        self.subscription_pricing = subscription_pricing

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x96\xbd,\xa2' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.revoked, 0)
                flags(self.permanent, 5)
                flags(self.request_needed, 6)
                writer.string(self.link)
                writer.long(self.admin_id)
                writer.int(self.date)

                if flags(self.start_date, 4):
                    writer.int(self.start_date)

                if flags(self.expire_date, 1):
                    writer.int(self.expire_date)

                if flags(self.usage_limit, 2):
                    writer.int(self.usage_limit)

                if flags(self.usage, 3):
                    writer.int(self.usage)

                if flags(self.requested, 7):
                    writer.int(self.requested)

                if flags(self.subscription_expired, 10):
                    writer.int(self.subscription_expired)

                if flags(self.title, 8):
                    writer.string(self.title)

                if flags(self.subscription_pricing, 9):
                    writer.object(
                        self.subscription_pricing,
                        group_id=0XB0E97E9F
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        link_ = reader.string()
        admin_id_ = reader.long()
        date_ = reader.int()
        start_date_ = (
            reader.int()
            if flags(4) else None
        )

        expire_date_ = (
            reader.int()
            if flags(1) else None
        )

        usage_limit_ = (
            reader.int()
            if flags(2) else None
        )

        usage_ = (
            reader.int()
            if flags(3) else None
        )

        requested_ = (
            reader.int()
            if flags(7) else None
        )

        subscription_expired_ = (
            reader.int()
            if flags(10) else None
        )

        title_ = (
            reader.string()
            if flags(8) else None
        )

        subscription_pricing_ = (
            reader.object(
                group_id=0XB0E97E9F
            )
            if flags(9) else None
        )

        return cls(
            link=link_,
            admin_id=admin_id_,
            date=date_,
            revoked=flags(0),
            permanent=flags(5),
            request_needed=flags(6),
            start_date=start_date_,
            expire_date=expire_date_,
            usage_limit=usage_limit_,
            usage=usage_,
            requested=requested_,
            subscription_expired=subscription_expired_,
            title=title_,
            subscription_pricing=subscription_pricing_
        )

class ChatInvitePublicJoinRequests(TLObject, family='TypeExportedChatInvite'):
    """
    Used in updates and in the channel log to indicate when a user is requesting to join or has joined a [discussion group](https://core.telegram.org/api/discussion#requiring-users-to-join-the-group)
    """

    _id = 0XED107AB7
    _group_id = 0X4C7FB2E0


    def to_bytes(self, boxed: bool=True):
        return b'\xb7z\x10\xed' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeExportedChatInvite = Union[
    ChatInviteExported,
    ChatInvitePublicJoinRequests
]