
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..document import TypeDocument
    from ..message_entity import TypeMessageEntity
    from ....gadgets.byteutils import Reader


class AppUpdate(TLObject, family='TypeHelpAppUpdate'):
    """
    An update is available for the application.
    """

    _id = 0XCCBBCE30
    _group_id = 0XA0ADB37F

    def __init__(
        self,
        id: int,
        version: str,
        text: str,
        entities: List['TypeMessageEntity'],
        can_not_skip: bool = False,
        document: Optional['TypeDocument'] = None,
        url: Optional[str] = None,
        sticker: Optional['TypeDocument'] = None
    ):

        """
        An update is available for the application.

        Args:
            id (int): Update ID
            version (str): New version name
            text (str): Text description of the update
            entities (List['TypeMessageEntity']): [Message entities for styled text](https://core.telegram.org/api/entities)
            can_not_skip (bool, optional): Unskippable, the new info must be shown to the user (with a popup or something else)
            document (Optional['TypeDocument'], optional): Application binary
            url (Optional[str], optional): Application download URL
            sticker (Optional['TypeDocument'], optional): Associated sticker
        """

        self.id = id
        self.version = version
        self.text = text
        self.entities = entities
        self.can_not_skip = can_not_skip
        self.document = document
        self.url = url
        self.sticker = sticker

    def to_bytes(self, boxed: bool=True):
        with Writer(b'0\xce\xbb\xcc' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.can_not_skip, 0)
                writer.int(self.id)
                writer.string(self.version)
                writer.string(self.text)
                writer.vector(
                    self.entities,
                    lambda value: writer.object(
                        value,
                        group_id=0X3CDFF38A
                    )
                )

                if flags(self.document, 1):
                    writer.object(
                        self.document,
                        group_id=0X6547BD50
                    )

                if flags(self.url, 2):
                    writer.string(self.url)

                if flags(self.sticker, 3):
                    writer.object(
                        self.sticker,
                        group_id=0X6547BD50
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        version_ = reader.string()
        text_ = reader.string()
        entities_ = reader.vector(
            lambda: reader.object(
                group_id=0X3CDFF38A
            )
        )

        document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(1) else None
        )

        url_ = (
            reader.string()
            if flags(2) else None
        )

        sticker_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(3) else None
        )

        return cls(
            id=id_,
            version=version_,
            text=text_,
            entities=entities_,
            can_not_skip=flags(0),
            document=document_,
            url=url_,
            sticker=sticker_
        )

class NoAppUpdate(TLObject, family='TypeHelpAppUpdate'):
    """
    No updates are available for the application.
    """

    _id = 0XC45A6536
    _group_id = 0XA0ADB37F


    def to_bytes(self, boxed: bool=True):
        return b'6eZ\xc4' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeHelpAppUpdate = Union[
    AppUpdate,
    NoAppUpdate
]