
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer_color_option import TypeHelpPeerColorOption
    from ....gadgets.byteutils import Reader


class PeerColorsNotModified(TLObject, family='TypeHelpPeerColors'):
    """
    The list of color palettes has not changed.
    """

    _id = 0X2BA1F5CE
    _group_id = 0XD9CA8F68


    def to_bytes(self, boxed: bool=True):
        return b'\xce\xf5\xa1+' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PeerColors(TLObject, family='TypeHelpPeerColors'):
    """
    Contains info about multiple [color palettes](https://core.telegram.org/api/colors).
    """

    _id = 0XF8ED08
    _group_id = 0XD9CA8F68

    def __init__(
        self,
        hash: int,
        colors: List['TypeHelpPeerColorOption']
    ):

        """
        Contains info about multiple [color palettes](https://core.telegram.org/api/colors).

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            colors (List['TypeHelpPeerColorOption']): Usable [color palettes](https://core.telegram.org/api/colors).
        """

        self.hash = hash
        self.colors = colors

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\xed\xf8\x00' if boxed else b'') as writer:
            writer.int(self.hash)
            writer.vector(
                self.colors,
                lambda value: writer.object(
                    value,
                    group_id=0X77C6DB76
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.int()
        colors_ = reader.vector(
            lambda: reader.object(
                group_id=0X77C6DB76
            )
        )

        return cls(
            hash=hash_,
            colors=colors_
        )

TypeHelpPeerColors = Union[
    PeerColorsNotModified,
    PeerColors
]