
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..data_json import TypeDataJSON
    from ..message_entity import TypeMessageEntity
    from ....gadgets.byteutils import Reader


class TermsOfService(TLObject, family='TypeHelpTermsOfService'):
    """
    Info about the latest telegram Terms Of Service
    """

    _id = 0X780A0310
    _group_id = 0XEA6FD826

    def __init__(
        self,
        id: 'TypeDataJSON',
        text: str,
        entities: List['TypeMessageEntity'],
        popup: bool = False,
        min_age_confirm: Optional[int] = None
    ):

        """
        Info about the latest telegram Terms Of Service

        Args:
            id ('TypeDataJSON'): ID of the new terms
            text (str): Text of the new terms
            entities (List['TypeMessageEntity']): [Message entities for styled text](https://core.telegram.org/api/entities)
            popup (bool, optional): Whether a prompt must be showed to the user, in order to accept the new terms.
            min_age_confirm (Optional[int], optional): Minimum age required to sign up to telegram, the user must confirm that they is older than the minimum age.
        """

        self.id = id
        self.text = text
        self.entities = entities
        self.popup = popup
        self.min_age_confirm = min_age_confirm

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x10\x03\nx' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.popup, 0)
                writer.object(
                    self.id,
                    group_id=0XE95B0798
                )
                writer.string(self.text)
                writer.vector(
                    self.entities,
                    lambda value: writer.object(
                        value,
                        group_id=0X3CDFF38A
                    )
                )

                if flags(self.min_age_confirm, 1):
                    writer.int(self.min_age_confirm)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.object(
            group_id=0XE95B0798
        )

        text_ = reader.string()
        entities_ = reader.vector(
            lambda: reader.object(
                group_id=0X3CDFF38A
            )
        )

        min_age_confirm_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            id=id_,
            text=text_,
            entities=entities_,
            popup=flags(0),
            min_age_confirm=min_age_confirm_
        )

TypeHelpTermsOfService = TermsOfService