
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .message_entity import TypeMessageEntity
    from ...gadgets.byteutils import Reader


class InputBusinessChatLink(TLObject, family='TypeInputBusinessChatLink'):
    """
    Contains info about a [business chat deep link](https://core.telegram.org/api/business#business-chat-links) to be created by the current account.
    """

    _id = 0X11679FA7
    _group_id = 0XE067CF30

    def __init__(
        self,
        message: str,
        entities: Optional[List['TypeMessageEntity']] = None,
        title: Optional[str] = None
    ):

        """
        Contains info about a [business chat deep link](https://core.telegram.org/api/business#business-chat-links) to be created by the current account.

        Args:
            message (str): Message to pre-fill in the message input field.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            title (Optional[str], optional): Human-readable name of the link, to simplify management in the UI (only visible to the creator of the link).
        """

        self.message = message
        self.entities = entities
        self.title = title

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa7\x9fg\x11' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.message)

                if flags(self.entities, 0):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.title, 1):
                    writer.string(self.title)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(0) else None
        )

        title_ = (
            reader.string()
            if flags(1) else None
        )

        return cls(
            message=message_,
            entities=entities_,
            title=title_
        )

TypeInputBusinessChatLink = InputBusinessChatLink