
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_user import TypeInputUser
    from ...gadgets.byteutils import Reader


class InputPrivacyValueAllowContacts(TLObject, family='TypeInputPrivacyRule'):
    """
    Allow only contacts
    """

    _id = 0XD09E07B
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'{\xe0\t\r' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPrivacyValueAllowAll(TLObject, family='TypeInputPrivacyRule'):
    """
    Allow all users
    """

    _id = 0X184B35CE
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'\xce5K\x18' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPrivacyValueAllowUsers(TLObject, family='TypeInputPrivacyRule'):
    """
    Allow only certain users
    """

    _id = 0X131CC67F
    _group_id = 0XCA2848B1

    def __init__(
        self,
        users: List['TypeInputUser']
    ):

        """
        Allow only certain users

        Args:
            users (List['TypeInputUser']): Allowed users
        """

        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x7f\xc6\x1c\x13' if boxed else b'') as writer:
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0XB628962F
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0XB628962F
            )
        )

        return cls(
            users=users_
        )

class InputPrivacyValueDisallowContacts(TLObject, family='TypeInputPrivacyRule'):
    """
    Disallow only contacts
    """

    _id = 0XBA52007
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'\x07 \xa5\x0b' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPrivacyValueDisallowAll(TLObject, family='TypeInputPrivacyRule'):
    """
    Disallow all
    """

    _id = 0XD66B66C9
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'\xc9fk\xd6' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPrivacyValueDisallowUsers(TLObject, family='TypeInputPrivacyRule'):
    """
    Disallow only certain users
    """

    _id = 0X90110467
    _group_id = 0XCA2848B1

    def __init__(
        self,
        users: List['TypeInputUser']
    ):

        """
        Disallow only certain users

        Args:
            users (List['TypeInputUser']): Users to disallow
        """

        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'g\x04\x11\x90' if boxed else b'') as writer:
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0XB628962F
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0XB628962F
            )
        )

        return cls(
            users=users_
        )

class InputPrivacyValueAllowChatParticipants(TLObject, family='TypeInputPrivacyRule'):
    """
    Allow only participants of certain chats
    """

    _id = 0X840649CF
    _group_id = 0XCA2848B1

    def __init__(
        self,
        chats: List[int]
    ):

        """
        Allow only participants of certain chats

        Args:
            chats (List[int]): Allowed chat IDs
        """

        self.chats = chats

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcfI\x06\x84' if boxed else b'') as writer:
            writer.vector(
                self.chats,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chats_ = reader.vector(
            reader.long
        )

        return cls(
            chats=chats_
        )

class InputPrivacyValueDisallowChatParticipants(TLObject, family='TypeInputPrivacyRule'):
    """
    Disallow only participants of certain chats
    """

    _id = 0XE94F0F86
    _group_id = 0XCA2848B1

    def __init__(
        self,
        chats: List[int]
    ):

        """
        Disallow only participants of certain chats

        Args:
            chats (List[int]): Disallowed chat IDs
        """

        self.chats = chats

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x86\x0fO\xe9' if boxed else b'') as writer:
            writer.vector(
                self.chats,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chats_ = reader.vector(
            reader.long
        )

        return cls(
            chats=chats_
        )

class InputPrivacyValueAllowCloseFriends(TLObject, family='TypeInputPrivacyRule'):
    """
    Allow only [close friends](https://core.telegram.org/api/privacy)
    """

    _id = 0X2F453E49
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'I>E/' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPrivacyValueAllowPremium(TLObject, family='TypeInputPrivacyRule'):
    """
    Allow only users with a [Premium subscription](https://core.telegram.org/api/premium), currently only usable for [inputPrivacyKeyChatInvite](https://core.telegram.org/constructor/inputPrivacyKeyChatInvite).
    """

    _id = 0X77CDC9F1
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'\xf1\xc9\xcdw' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPrivacyValueAllowBots(TLObject, family='TypeInputPrivacyRule'):
    """
    Allow bots and mini apps
    """

    _id = 0X5A4FCCE5
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'\xe5\xccOZ' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPrivacyValueDisallowBots(TLObject, family='TypeInputPrivacyRule'):
    """
    Disallow bots and mini apps
    """

    _id = 0XC4E57915
    _group_id = 0XCA2848B1


    def to_bytes(self, boxed: bool=True):
        return b'\x15y\xe5\xc4' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeInputPrivacyRule = Union[
    InputPrivacyValueAllowContacts,
    InputPrivacyValueAllowAll,
    InputPrivacyValueAllowUsers,
    InputPrivacyValueDisallowContacts,
    InputPrivacyValueDisallowAll,
    InputPrivacyValueDisallowUsers,
    InputPrivacyValueAllowChatParticipants,
    InputPrivacyValueDisallowChatParticipants,
    InputPrivacyValueAllowCloseFriends,
    InputPrivacyValueAllowPremium,
    InputPrivacyValueAllowBots,
    InputPrivacyValueDisallowBots
]