
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_peer import TypeInputPeer
    from .message_entity import TypeMessageEntity
    from ...gadgets.byteutils import Reader


class InputReplyToMessage(TLObject, family='TypeInputReplyTo'):
    """
    Reply to a message.
    """

    _id = 0X869FBE10
    _group_id = 0X8EEA0D0F

    def __init__(
        self,
        reply_to_msg_id: int,
        top_msg_id: Optional[int] = None,
        reply_to_peer_id: Optional['TypeInputPeer'] = None,
        quote_text: Optional[str] = None,
        quote_entities: Optional[List['TypeMessageEntity']] = None,
        quote_offset: Optional[int] = None,
        monoforum_peer_id: Optional['TypeInputPeer'] = None,
        todo_item_id: Optional[int] = None
    ):

        """
        Reply to a message.

        Args:
            reply_to_msg_id (int): The message ID to reply to.
            top_msg_id (Optional[int], optional): This field must contain the topic ID only when replying to messages in forum topics different from the "General" topic (i.e. reply_to_msg_id is set and reply_to_msg_id != topicID and topicID != 1).  If the replied-to message is deleted before the method finishes execution, the value in this field will be used to send the message to the correct topic, instead of the "General" topic.
            reply_to_peer_id (Optional['TypeInputPeer'], optional): Used to reply to messages sent to another chat (specified here), can only be used for non- protected chats and messages.
            quote_text (Optional[str], optional): Used to quote-reply to only a certain section (specified here) of the original message. The maximum UTF-8 length for quotes is specified in the [quote_length_max](https://core.telegram.org/api/config#quote-length-max) config key.
            quote_entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities) from the quote_text field.
            quote_offset (Optional[int], optional): Offset of the message quote_text within the original message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length)).
            monoforum_peer_id (Optional['TypeInputPeer'], optional): ...
            todo_item_id (Optional[int], optional): ...
        """

        self.reply_to_msg_id = reply_to_msg_id
        self.top_msg_id = top_msg_id
        self.reply_to_peer_id = reply_to_peer_id
        self.quote_text = quote_text
        self.quote_entities = quote_entities
        self.quote_offset = quote_offset
        self.monoforum_peer_id = monoforum_peer_id
        self.todo_item_id = todo_item_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x10\xbe\x9f\x86' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.reply_to_msg_id)

                if flags(self.top_msg_id, 0):
                    writer.int(self.top_msg_id)

                if flags(self.reply_to_peer_id, 1):
                    writer.object(
                        self.reply_to_peer_id,
                        group_id=0X995DB9DF
                    )

                if flags(self.quote_text, 2):
                    writer.string(self.quote_text)

                if flags(self.quote_entities, 3):
                    writer.vector(
                        self.quote_entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.quote_offset, 4):
                    writer.int(self.quote_offset)

                if flags(self.monoforum_peer_id, 5):
                    writer.object(
                        self.monoforum_peer_id,
                        group_id=0X995DB9DF
                    )

                if flags(self.todo_item_id, 6):
                    writer.int(self.todo_item_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        reply_to_msg_id_ = reader.int()
        top_msg_id_ = (
            reader.int()
            if flags(0) else None
        )

        reply_to_peer_id_ = (
            reader.object(
                group_id=0X995DB9DF
            )
            if flags(1) else None
        )

        quote_text_ = (
            reader.string()
            if flags(2) else None
        )

        quote_entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(3) else None
        )

        quote_offset_ = (
            reader.int()
            if flags(4) else None
        )

        monoforum_peer_id_ = (
            reader.object(
                group_id=0X995DB9DF
            )
            if flags(5) else None
        )

        todo_item_id_ = (
            reader.int()
            if flags(6) else None
        )

        return cls(
            reply_to_msg_id=reply_to_msg_id_,
            top_msg_id=top_msg_id_,
            reply_to_peer_id=reply_to_peer_id_,
            quote_text=quote_text_,
            quote_entities=quote_entities_,
            quote_offset=quote_offset_,
            monoforum_peer_id=monoforum_peer_id_,
            todo_item_id=todo_item_id_
        )

class InputReplyToStory(TLObject, family='TypeInputReplyTo'):
    """
    Reply to a story.
    """

    _id = 0X5881323A
    _group_id = 0X8EEA0D0F

    def __init__(
        self,
        peer: 'TypeInputPeer',
        story_id: int
    ):

        """
        Reply to a story.

        Args:
            peer ('TypeInputPeer'): Sender of the story
            story_id (int): ID of the story to reply to.
        """

        self.peer = peer
        self.story_id = story_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b':2\x81X' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.story_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        story_id_ = reader.int()

        return cls(
            peer=peer_,
            story_id=story_id_
        )

class InputReplyToMonoForum(TLObject, family='TypeInputReplyTo'):
    _id = 0X69D66C45
    _group_id = 0X8EEA0D0F

    def __init__(
        self,
        monoforum_peer_id: 'TypeInputPeer'
    ):

        self.monoforum_peer_id = monoforum_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'El\xd6i' if boxed else b'') as writer:
            writer.object(
                self.monoforum_peer_id,
                group_id=0X995DB9DF
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        monoforum_peer_id_ = reader.object(
            group_id=0X995DB9DF
        )

        return cls(
            monoforum_peer_id=monoforum_peer_id_
        )

TypeInputReplyTo = Union[
    InputReplyToMessage,
    InputReplyToStory,
    InputReplyToMonoForum
]