
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .labeled_price import TypeLabeledPrice
    from ...gadgets.byteutils import Reader


class Invoice(TLObject, family='TypeInvoice'):
    """
    Invoice
    """

    _id = 0X49EE584
    _group_id = 0X3A02DB4

    def __init__(
        self,
        currency: str,
        prices: List['TypeLabeledPrice'],
        test: bool = False,
        name_requested: bool = False,
        phone_requested: bool = False,
        email_requested: bool = False,
        shipping_address_requested: bool = False,
        flexible: bool = False,
        phone_to_provider: bool = False,
        email_to_provider: bool = False,
        recurring: bool = False,
        max_tip_amount: Optional[int] = None,
        suggested_tip_amounts: Optional[List[int]] = None,
        terms_url: Optional[str] = None,
        subscription_period: Optional[int] = None
    ):

        """
        Invoice

        Args:
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code, or XTR for [Telegram Stars](https://core.telegram.org/api/stars).
            prices (List['TypeLabeledPrice']): Price breakdown, a list of components (e.g. product price, tax, discount, delivery cost, delivery tax, bonus, etc.)
            test (bool, optional): Test invoice
            name_requested (bool, optional): Set this flag if you require the user's full name to complete the order
            phone_requested (bool, optional): Set this flag if you require the user's phone number to complete the order
            email_requested (bool, optional): Set this flag if you require the user's email address to complete the order
            shipping_address_requested (bool, optional): Set this flag if you require the user's shipping address to complete the order
            flexible (bool, optional): Set this flag if the final price depends on the shipping method
            phone_to_provider (bool, optional): Set this flag if user's phone number should be sent to provider
            email_to_provider (bool, optional): Set this flag if user's email address should be sent to provider
            recurring (bool, optional): Whether this is a recurring payment
            max_tip_amount (Optional[int], optional): The maximum accepted amount for tips in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            suggested_tip_amounts (Optional[List[int]], optional): A vector of suggested amounts of tips in the smallest units of the currency (integer, not float/double). At most 4 suggested tip amounts can be specified. The suggested tip amounts must be positive, passed in a strictly increased order and must not exceed max_tip_amount.
            terms_url (Optional[str], optional): Terms of service URL
            subscription_period (Optional[int], optional): The number of seconds between consecutive Telegram Star debiting for [bot subscription](https://core.telegram.org/api/subscriptions#bot-subscriptions) invoices
        """

        self.currency = currency
        self.prices = prices
        self.test = test
        self.name_requested = name_requested
        self.phone_requested = phone_requested
        self.email_requested = email_requested
        self.shipping_address_requested = shipping_address_requested
        self.flexible = flexible
        self.phone_to_provider = phone_to_provider
        self.email_to_provider = email_to_provider
        self.recurring = recurring
        self.max_tip_amount = max_tip_amount
        self.suggested_tip_amounts = suggested_tip_amounts
        self.terms_url = terms_url
        self.subscription_period = subscription_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x84\xe5\x9e\x04' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.test, 0)
                flags(self.name_requested, 1)
                flags(self.phone_requested, 2)
                flags(self.email_requested, 3)
                flags(self.shipping_address_requested, 4)
                flags(self.flexible, 5)
                flags(self.phone_to_provider, 6)
                flags(self.email_to_provider, 7)
                flags(self.recurring, 9)
                writer.string(self.currency)
                writer.vector(
                    self.prices,
                    lambda value: writer.object(
                        value,
                        group_id=0X1E1F1A68
                    )
                )

                if flags(self.max_tip_amount, 8):
                    writer.long(self.max_tip_amount)

                if flags(self.suggested_tip_amounts, 8):
                    writer.vector(
                        self.suggested_tip_amounts,
                        writer.long
                    )

                if flags(self.terms_url, 10):
                    writer.string(self.terms_url)

                if flags(self.subscription_period, 11):
                    writer.int(self.subscription_period)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        currency_ = reader.string()
        prices_ = reader.vector(
            lambda: reader.object(
                group_id=0X1E1F1A68
            )
        )

        max_tip_amount_ = (
            reader.long()
            if flags(8) else None
        )

        suggested_tip_amounts_ = (
            reader.vector(
                reader.long
            )
            if flags(8) else None
        )

        terms_url_ = (
            reader.string()
            if flags(10) else None
        )

        subscription_period_ = (
            reader.int()
            if flags(11) else None
        )

        return cls(
            currency=currency_,
            prices=prices_,
            test=flags(0),
            name_requested=flags(1),
            phone_requested=flags(2),
            email_requested=flags(3),
            shipping_address_requested=flags(4),
            flexible=flags(5),
            phone_to_provider=flags(6),
            email_to_provider=flags(7),
            recurring=flags(9),
            max_tip_amount=max_tip_amount_,
            suggested_tip_amounts=suggested_tip_amounts_,
            terms_url=terms_url_,
            subscription_period=subscription_period_
        )

TypeInvoice = Invoice