
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .fact_check import TypeFactCheck
    from .reply_markup import TypeReplyMarkup
    from .message_media import TypeMessageMedia
    from .message_entity import TypeMessageEntity
    from .suggested_post import TypeSuggestedPost
    from .message_action import TypeMessageAction
    from .message_replies import TypeMessageReplies
    from .message_reactions import TypeMessageReactions
    from .message_fwd_header import TypeMessageFwdHeader
    from .restriction_reason import TypeRestrictionReason
    from ...gadgets.byteutils import Reader
    from .message_reply_header import TypeMessageReplyHeader


class MessageEmpty(TLObject, family='TypeMessage'):
    """
    Empty constructor, non-existent message.
    """

    _id = 0X90A6CA84
    _group_id = 0X25780A8F

    def __init__(
        self,
        id: int,
        peer_id: Optional['TypePeer'] = None
    ):

        """
        Empty constructor, non-existent message.

        Args:
            id (int): Message identifier
            peer_id (Optional['TypePeer'], optional): Peer ID, the chat where this message was sent
        """

        self.id = id
        self.peer_id = peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x84\xca\xa6\x90' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.id)

                if flags(self.peer_id, 0):
                    writer.object(
                        self.peer_id,
                        group_id=0XB4DECBCA
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(0) else None
        )

        return cls(
            id=id_,
            peer_id=peer_id_
        )

class Message(TLObject, family='TypeMessage'):
    """
    A message
    """

    _id = 0X9815CEC8
    _group_id = 0X25780A8F

    def __init__(
        self,
        id: int,
        peer_id: 'TypePeer',
        date: int,
        message: str,
        out: bool = False,
        mentioned: bool = False,
        media_unread: bool = False,
        silent: bool = False,
        post: bool = False,
        from_scheduled: bool = False,
        legacy: bool = False,
        edit_hide: bool = False,
        pinned: bool = False,
        noforwards: bool = False,
        invert_media: bool = False,
        offline: bool = False,
        video_processing_pending: bool = False,
        paid_suggested_post_stars: bool = False,
        paid_suggested_post_ton: bool = False,
        from_id: Optional['TypePeer'] = None,
        from_boosts_applied: Optional[int] = None,
        saved_peer_id: Optional['TypePeer'] = None,
        fwd_from: Optional['TypeMessageFwdHeader'] = None,
        via_bot_id: Optional[int] = None,
        via_business_bot_id: Optional[int] = None,
        reply_to: Optional['TypeMessageReplyHeader'] = None,
        media: Optional['TypeMessageMedia'] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        views: Optional[int] = None,
        forwards: Optional[int] = None,
        replies: Optional['TypeMessageReplies'] = None,
        edit_date: Optional[int] = None,
        post_author: Optional[str] = None,
        grouped_id: Optional[int] = None,
        reactions: Optional['TypeMessageReactions'] = None,
        restriction_reason: Optional[List['TypeRestrictionReason']] = None,
        ttl_period: Optional[int] = None,
        quick_reply_shortcut_id: Optional[int] = None,
        effect: Optional[int] = None,
        factcheck: Optional['TypeFactCheck'] = None,
        report_delivery_until_date: Optional[int] = None,
        paid_message_stars: Optional[int] = None,
        suggested_post: Optional['TypeSuggestedPost'] = None
    ):

        """
        A message

        Args:
            id (int): ID of the message
            peer_id ('TypePeer'): Peer ID, the chat where this message was sent
            date (int): Date of the message
            message (str): The message
            out (bool, optional): Is this an outgoing message
            mentioned (bool, optional): Whether we were [mentioned](https://core.telegram.org/api/mentions) in this message
            media_unread (bool, optional): Whether there are unread media attachments in this message
            silent (bool, optional): Whether this is a silent message (no notification triggered)
            post (bool, optional): Whether this is a channel post
            from_scheduled (bool, optional): Whether this is a [scheduled message](https://core.telegram.org/api/scheduled-messages)
            legacy (bool, optional): This is a legacy message: it has to be refetched with the new layer
            edit_hide (bool, optional): Whether the message should be shown as not modified to the user, even if an edit date is present
            pinned (bool, optional): Whether this message is [pinned](https://core.telegram.org/api/pin)
            noforwards (bool, optional): Whether this message is [protected](https://telegram.org/blog/protected-content-delete-by-date-and-more) and thus cannot be forwarded; clients should also prevent users from saving attached media (i.e. videos should only be streamed, photos should be kept in RAM, et cetera).
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            offline (bool, optional): If set, the message was sent because of a scheduled action by the message sender, for example, as away, or a greeting service message.
            video_processing_pending (bool, optional): The video contained in the message is currently being processed by the server (i.e. to generate alternative qualities, that will be contained in the final [messageMediaDocument](https://core.telegram.org/constructor/messageMediaDocument). alt_document), and will be sent once the video is processed, which will happen approximately at the specified date (i.e. messages with this flag set should be treated similarly to [scheduled messages](https://core.telegram.org/api/scheduled-messages), but instead of the scheduled date, date contains the estimated conversion date). See [here](https://core.telegram.org/api/files#video-qualities) for more info.
            paid_suggested_post_stars (bool, optional): ...
            paid_suggested_post_ton (bool, optional): ...
            from_id (Optional['TypePeer'], optional): ID of the sender of the message
            from_boosts_applied (Optional[int], optional): Supergroups only, contains the number of [boosts](https://core.telegram.org/api/boost) this user has given the current supergroup, and should be shown in the UI in the header of the message. Only present for incoming messages from non-anonymous supergroup members that have boosted the supergroup. Note that this counter should be locally overridden for non-anonymous outgoing messages, according to the current value of [channelFull](https://core.telegram.org/constructor/channelFull). boosts_applied, to ensure the value is correct even for messages sent by the current user before a supergroup was boosted (or after a boost has expired or the number of boosts has changed); do not update this value for incoming messages from other users, even if their boosts have changed.
            saved_peer_id (Optional['TypePeer'], optional): Messages fetched from a [saved messages dialog](https://core.telegram.org/api/saved-messages) will have peer= [inputPeerSelf](https://core.telegram.org/constructor/inputPeerSelf) and the saved_peer_id flag set to the ID of the saved dialog.
            fwd_from (Optional['TypeMessageFwdHeader'], optional): Info about forwarded messages
            via_bot_id (Optional[int], optional): ID of the inline bot that generated the message
            via_business_bot_id (Optional[int], optional): Whether the message was sent by the [business bot](https://core.telegram.org/api/business#connected-bots) specified in via_bot_id on behalf of the user.
            reply_to (Optional['TypeMessageReplyHeader'], optional): Reply information
            media (Optional['TypeMessageMedia'], optional): Media attachment
            reply_markup (Optional['TypeReplyMarkup'], optional): Reply markup (bot/inline keyboards)
            entities (Optional[List['TypeMessageEntity']], optional): Message [entities](https://core.telegram.org/api/entities) for styled text
            views (Optional[int], optional): View count for channel posts
            forwards (Optional[int], optional): Forward counter
            replies (Optional['TypeMessageReplies'], optional): Info about [post comments (for channels) or message replies (for groups)](https://core.telegram.org/api/threads)
            edit_date (Optional[int], optional): Last edit date of this message
            post_author (Optional[str], optional): Name of the author of this message for channel posts (with signatures enabled)
            grouped_id (Optional[int], optional): Multiple media messages sent using [messages.sendMultiMedia](https://core.telegram.org/method/messages.sendMultiMedia) with the same grouped ID indicate an [album or media group](https://core.telegram.org/api/files#albums-grouped-media)
            reactions (Optional['TypeMessageReactions'], optional): Reactions to this message
            restriction_reason (Optional[List['TypeRestrictionReason']], optional): Contains the reason why access to this message must be restricted.
            ttl_period (Optional[int], optional): Time To Live of the message, once message.date+message.ttl_period === time(), the message will be deleted on the server, and must be deleted locally as well.
            quick_reply_shortcut_id (Optional[int], optional): If set, this message is a [quick reply shortcut message](https://core.telegram.org/api/business#quick-reply-shortcuts) (note that quick reply shortcut messages sent to a private chat will not have this field set).
            effect (Optional[int], optional): A [message effect that should be played as specified here](https://core.telegram.org/api/effects).
            factcheck (Optional['TypeFactCheck'], optional): Represents a [fact-check](https://core.telegram.org/api/factcheck).
            report_delivery_until_date (Optional[int], optional): ...
            paid_message_stars (Optional[int], optional): ...
            suggested_post (Optional['TypeSuggestedPost'], optional): ...
        """

        self.id = id
        self.peer_id = peer_id
        self.date = date
        self.message = message
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.silent = silent
        self.post = post
        self.from_scheduled = from_scheduled
        self.legacy = legacy
        self.edit_hide = edit_hide
        self.pinned = pinned
        self.noforwards = noforwards
        self.invert_media = invert_media
        self.offline = offline
        self.video_processing_pending = video_processing_pending
        self.paid_suggested_post_stars = paid_suggested_post_stars
        self.paid_suggested_post_ton = paid_suggested_post_ton
        self.from_id = from_id
        self.from_boosts_applied = from_boosts_applied
        self.saved_peer_id = saved_peer_id
        self.fwd_from = fwd_from
        self.via_bot_id = via_bot_id
        self.via_business_bot_id = via_business_bot_id
        self.reply_to = reply_to
        self.media = media
        self.reply_markup = reply_markup
        self.entities = entities
        self.views = views
        self.forwards = forwards
        self.replies = replies
        self.edit_date = edit_date
        self.post_author = post_author
        self.grouped_id = grouped_id
        self.reactions = reactions
        self.restriction_reason = restriction_reason
        self.ttl_period = ttl_period
        self.quick_reply_shortcut_id = quick_reply_shortcut_id
        self.effect = effect
        self.factcheck = factcheck
        self.report_delivery_until_date = report_delivery_until_date
        self.paid_message_stars = paid_message_stars
        self.suggested_post = suggested_post

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc8\xce\x15\x98' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.out, 1)
                flags(self.mentioned, 4)
                flags(self.media_unread, 5)
                flags(self.silent, 13)
                flags(self.post, 14)
                flags(self.from_scheduled, 18)
                flags(self.legacy, 19)
                flags(self.edit_hide, 21)
                flags(self.pinned, 24)
                flags(self.noforwards, 26)
                flags(self.invert_media, 27)

                with writer.flag() as flags2:
                    flags2(self.offline, 1)
                    flags2(self.video_processing_pending, 4)
                    flags2(self.paid_suggested_post_stars, 8)
                    flags2(self.paid_suggested_post_ton, 9)
                    writer.int(self.id)

                    if flags(self.from_id, 8):
                        writer.object(
                            self.from_id,
                            group_id=0XB4DECBCA
                        )

                    if flags(self.from_boosts_applied, 29):
                        writer.int(self.from_boosts_applied)
                    writer.object(
                        self.peer_id,
                        group_id=0XB4DECBCA
                    )

                    if flags(self.saved_peer_id, 28):
                        writer.object(
                            self.saved_peer_id,
                            group_id=0XB4DECBCA
                        )

                    if flags(self.fwd_from, 2):
                        writer.object(
                            self.fwd_from,
                            group_id=0XEA3B4B97
                        )

                    if flags(self.via_bot_id, 11):
                        writer.long(self.via_bot_id)

                    if flags2(self.via_business_bot_id, 0):
                        writer.long(self.via_business_bot_id)

                    if flags(self.reply_to, 3):
                        writer.object(
                            self.reply_to,
                            group_id=0XA346A9DF
                        )
                    writer.int(self.date)
                    writer.string(self.message)

                    if flags(self.media, 9):
                        writer.object(
                            self.media,
                            group_id=0X45F7A020
                        )

                    if flags(self.reply_markup, 6):
                        writer.object(
                            self.reply_markup,
                            group_id=0X146C1631
                        )

                    if flags(self.entities, 7):
                        writer.vector(
                            self.entities,
                            lambda value: writer.object(
                                value,
                                group_id=0X3CDFF38A
                            )
                        )

                    if flags(self.views, 10):
                        writer.int(self.views)

                    if flags(self.forwards, 10):
                        writer.int(self.forwards)

                    if flags(self.replies, 23):
                        writer.object(
                            self.replies,
                            group_id=0XEE3613C9
                        )

                    if flags(self.edit_date, 15):
                        writer.int(self.edit_date)

                    if flags(self.post_author, 16):
                        writer.string(self.post_author)

                    if flags(self.grouped_id, 17):
                        writer.long(self.grouped_id)

                    if flags(self.reactions, 20):
                        writer.object(
                            self.reactions,
                            group_id=0X1A48248F
                        )

                    if flags(self.restriction_reason, 22):
                        writer.vector(
                            self.restriction_reason,
                            lambda value: writer.object(
                                value,
                                group_id=0X6F3B4470
                            )
                        )

                    if flags(self.ttl_period, 25):
                        writer.int(self.ttl_period)

                    if flags(self.quick_reply_shortcut_id, 30):
                        writer.int(self.quick_reply_shortcut_id)

                    if flags2(self.effect, 2):
                        writer.long(self.effect)

                    if flags2(self.factcheck, 3):
                        writer.object(
                            self.factcheck,
                            group_id=0X16018ACA
                        )

                    if flags2(self.report_delivery_until_date, 5):
                        writer.int(self.report_delivery_until_date)

                    if flags2(self.paid_message_stars, 6):
                        writer.long(self.paid_message_stars)

                    if flags2(self.suggested_post, 7):
                        writer.object(
                            self.suggested_post,
                            group_id=0X7DC96856
                        )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        flags2 = reader.flag()
        id_ = reader.int()
        from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(8) else None
        )

        from_boosts_applied_ = (
            reader.int()
            if flags(29) else None
        )

        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        saved_peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(28) else None
        )

        fwd_from_ = (
            reader.object(
                group_id=0XEA3B4B97
            )
            if flags(2) else None
        )

        via_bot_id_ = (
            reader.long()
            if flags(11) else None
        )

        via_business_bot_id_ = (
            reader.long()
            if flags2(0) else None
        )

        reply_to_ = (
            reader.object(
                group_id=0XA346A9DF
            )
            if flags(3) else None
        )

        date_ = reader.int()
        message_ = reader.string()
        media_ = (
            reader.object(
                group_id=0X45F7A020
            )
            if flags(9) else None
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(6) else None
        )

        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(7) else None
        )

        views_ = (
            reader.int()
            if flags(10) else None
        )

        forwards_ = (
            reader.int()
            if flags(10) else None
        )

        replies_ = (
            reader.object(
                group_id=0XEE3613C9
            )
            if flags(23) else None
        )

        edit_date_ = (
            reader.int()
            if flags(15) else None
        )

        post_author_ = (
            reader.string()
            if flags(16) else None
        )

        grouped_id_ = (
            reader.long()
            if flags(17) else None
        )

        reactions_ = (
            reader.object(
                group_id=0X1A48248F
            )
            if flags(20) else None
        )

        restriction_reason_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X6F3B4470
                )
            )
            if flags(22) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(25) else None
        )

        quick_reply_shortcut_id_ = (
            reader.int()
            if flags(30) else None
        )

        effect_ = (
            reader.long()
            if flags2(2) else None
        )

        factcheck_ = (
            reader.object(
                group_id=0X16018ACA
            )
            if flags2(3) else None
        )

        report_delivery_until_date_ = (
            reader.int()
            if flags2(5) else None
        )

        paid_message_stars_ = (
            reader.long()
            if flags2(6) else None
        )

        suggested_post_ = (
            reader.object(
                group_id=0X7DC96856
            )
            if flags2(7) else None
        )

        return cls(
            id=id_,
            peer_id=peer_id_,
            date=date_,
            message=message_,
            out=flags(1),
            mentioned=flags(4),
            media_unread=flags(5),
            silent=flags(13),
            post=flags(14),
            from_scheduled=flags(18),
            legacy=flags(19),
            edit_hide=flags(21),
            pinned=flags(24),
            noforwards=flags(26),
            invert_media=flags(27),
            offline=flags2(1),
            video_processing_pending=flags2(4),
            paid_suggested_post_stars=flags2(8),
            paid_suggested_post_ton=flags2(9),
            from_id=from_id_,
            from_boosts_applied=from_boosts_applied_,
            saved_peer_id=saved_peer_id_,
            fwd_from=fwd_from_,
            via_bot_id=via_bot_id_,
            via_business_bot_id=via_business_bot_id_,
            reply_to=reply_to_,
            media=media_,
            reply_markup=reply_markup_,
            entities=entities_,
            views=views_,
            forwards=forwards_,
            replies=replies_,
            edit_date=edit_date_,
            post_author=post_author_,
            grouped_id=grouped_id_,
            reactions=reactions_,
            restriction_reason=restriction_reason_,
            ttl_period=ttl_period_,
            quick_reply_shortcut_id=quick_reply_shortcut_id_,
            effect=effect_,
            factcheck=factcheck_,
            report_delivery_until_date=report_delivery_until_date_,
            paid_message_stars=paid_message_stars_,
            suggested_post=suggested_post_
        )

class MessageService(TLObject, family='TypeMessage'):
    """
    Indicates a service message
    """

    _id = 0X7A800E0A
    _group_id = 0X25780A8F

    def __init__(
        self,
        id: int,
        peer_id: 'TypePeer',
        date: int,
        action: 'TypeMessageAction',
        out: bool = False,
        mentioned: bool = False,
        media_unread: bool = False,
        reactions_are_possible: bool = False,
        silent: bool = False,
        post: bool = False,
        legacy: bool = False,
        from_id: Optional['TypePeer'] = None,
        saved_peer_id: Optional['TypePeer'] = None,
        reply_to: Optional['TypeMessageReplyHeader'] = None,
        reactions: Optional['TypeMessageReactions'] = None,
        ttl_period: Optional[int] = None
    ):

        """
        Indicates a service message

        Args:
            id (int): Message ID
            peer_id ('TypePeer'): Sender of service message
            date (int): Message date
            action ('TypeMessageAction'): Event connected with the service message
            out (bool, optional): Whether the message is outgoing
            mentioned (bool, optional): Whether we were mentioned in the message
            media_unread (bool, optional): Whether the message contains unread media
            reactions_are_possible (bool, optional): ...
            silent (bool, optional): Whether the message is silent
            post (bool, optional): Whether it's a channel post
            legacy (bool, optional): This is a legacy message: it has to be refetched with the new layer
            from_id (Optional['TypePeer'], optional): ID of the sender of this message
            saved_peer_id (Optional['TypePeer'], optional): ...
            reply_to (Optional['TypeMessageReplyHeader'], optional): Reply (thread) information
            reactions (Optional['TypeMessageReactions'], optional): ...
            ttl_period (Optional[int], optional): Time To Live of the message, once message.date+message.ttl_period === time(), the message will be deleted on the server, and must be deleted locally as well.
        """

        self.id = id
        self.peer_id = peer_id
        self.date = date
        self.action = action
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.reactions_are_possible = reactions_are_possible
        self.silent = silent
        self.post = post
        self.legacy = legacy
        self.from_id = from_id
        self.saved_peer_id = saved_peer_id
        self.reply_to = reply_to
        self.reactions = reactions
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\n\x0e\x80z' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.out, 1)
                flags(self.mentioned, 4)
                flags(self.media_unread, 5)
                flags(self.reactions_are_possible, 9)
                flags(self.silent, 13)
                flags(self.post, 14)
                flags(self.legacy, 19)
                writer.int(self.id)

                if flags(self.from_id, 8):
                    writer.object(
                        self.from_id,
                        group_id=0XB4DECBCA
                    )
                writer.object(
                    self.peer_id,
                    group_id=0XB4DECBCA
                )

                if flags(self.saved_peer_id, 28):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.reply_to, 3):
                    writer.object(
                        self.reply_to,
                        group_id=0XA346A9DF
                    )
                writer.int(self.date)
                writer.object(
                    self.action,
                    group_id=0X753B3B70
                )

                if flags(self.reactions, 20):
                    writer.object(
                        self.reactions,
                        group_id=0X1A48248F
                    )

                if flags(self.ttl_period, 25):
                    writer.int(self.ttl_period)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        from_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(8) else None
        )

        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        saved_peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(28) else None
        )

        reply_to_ = (
            reader.object(
                group_id=0XA346A9DF
            )
            if flags(3) else None
        )

        date_ = reader.int()
        action_ = reader.object(
            group_id=0X753B3B70
        )

        reactions_ = (
            reader.object(
                group_id=0X1A48248F
            )
            if flags(20) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(25) else None
        )

        return cls(
            id=id_,
            peer_id=peer_id_,
            date=date_,
            action=action_,
            out=flags(1),
            mentioned=flags(4),
            media_unread=flags(5),
            reactions_are_possible=flags(9),
            silent=flags(13),
            post=flags(14),
            legacy=flags(19),
            from_id=from_id_,
            saved_peer_id=saved_peer_id_,
            reply_to=reply_to_,
            reactions=reactions_,
            ttl_period=ttl_period_
        )

TypeMessage = Union[
    MessageEmpty,
    Message,
    MessageService
]