
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .message_replies import TypeMessageReplies
    from ...gadgets.byteutils import Reader


class MessageViews(TLObject, family='TypeMessageViews'):
    """
    View, forward counter + info about replies of a specific message
    """

    _id = 0X455B853D
    _group_id = 0X3E2B9DAB

    def __init__(
        self,
        views: Optional[int] = None,
        forwards: Optional[int] = None,
        replies: Optional['TypeMessageReplies'] = None
    ):

        """
        View, forward counter + info about replies of a specific message

        Args:
            views (Optional[int], optional): View count of message
            forwards (Optional[int], optional): Forward count of message
            replies (Optional['TypeMessageReplies'], optional): Reply and [thread](https://core.telegram.org/api/threads) information of message
        """

        self.views = views
        self.forwards = forwards
        self.replies = replies

    def to_bytes(self, boxed: bool=True):
        with Writer(b'=\x85[E' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.views, 0):
                    writer.int(self.views)

                if flags(self.forwards, 1):
                    writer.int(self.forwards)

                if flags(self.replies, 2):
                    writer.object(
                        self.replies,
                        group_id=0XEE3613C9
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        views_ = (
            reader.int()
            if flags(0) else None
        )

        forwards_ = (
            reader.int()
            if flags(1) else None
        )

        replies_ = (
            reader.object(
                group_id=0XEE3613C9
            )
            if flags(2) else None
        )

        return cls(
            views=views_,
            forwards=forwards_,
            replies=replies_
        )

TypeMessageViews = MessageViews