
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..dialog import TypeDialog
    from ..message import TypeMessage
    from ....gadgets.byteutils import Reader


class Dialogs(TLObject, family='TypeMessagesDialogs'):
    """
    Full list of chats with messages and auxiliary data.
    """

    _id = 0X15BA6C40
    _group_id = 0X6DE0E6BF

    def __init__(
        self,
        dialogs: List['TypeDialog'],
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Full list of chats with messages and auxiliary data.

        Args:
            dialogs (List['TypeDialog']): List of chats
            messages (List['TypeMessage']): List of last messages from each chat
            chats (List['TypeChat']): List of groups mentioned in the chats
            users (List['TypeUser']): List of users mentioned in messages and groups
        """

        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'@l\xba\x15' if boxed else b'') as writer:
            writer.vector(
                self.dialogs,
                lambda value: writer.object(
                    value,
                    group_id=0X89A4B5EF
                )
            )
            writer.vector(
                self.messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dialogs_ = reader.vector(
            lambda: reader.object(
                group_id=0X89A4B5EF
            )
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            dialogs=dialogs_,
            messages=messages_,
            chats=chats_,
            users=users_
        )

class DialogsSlice(TLObject, family='TypeMessagesDialogs'):
    """
    Incomplete list of dialogs with messages and auxiliary data.
    """

    _id = 0X71E094F3
    _group_id = 0X6DE0E6BF

    def __init__(
        self,
        count: int,
        dialogs: List['TypeDialog'],
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Incomplete list of dialogs with messages and auxiliary data.

        Args:
            count (int): Total number of dialogs
            dialogs (List['TypeDialog']): List of dialogs
            messages (List['TypeMessage']): List of last messages from dialogs
            chats (List['TypeChat']): List of chats mentioned in dialogs
            users (List['TypeUser']): List of users mentioned in messages and chats
        """

        self.count = count
        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf3\x94\xe0q' if boxed else b'') as writer:
            writer.int(self.count)
            writer.vector(
                self.dialogs,
                lambda value: writer.object(
                    value,
                    group_id=0X89A4B5EF
                )
            )
            writer.vector(
                self.messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        dialogs_ = reader.vector(
            lambda: reader.object(
                group_id=0X89A4B5EF
            )
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            dialogs=dialogs_,
            messages=messages_,
            chats=chats_,
            users=users_
        )

class DialogsNotModified(TLObject, family='TypeMessagesDialogs'):
    """
    Dialogs haven't changed
    """

    _id = 0XF0E3E596
    _group_id = 0X6DE0E6BF

    def __init__(
        self,
        count: int
    ):

        """
        Dialogs haven't changed

        Args:
            count (int): Number of dialogs found server-side by the query
        """

        self.count = count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x96\xe5\xe3\xf0' if boxed else b'') as writer:
            writer.int(self.count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()

        return cls(
            count=count_
        )

TypeMessagesDialogs = Union[
    Dialogs,
    DialogsSlice,
    DialogsNotModified
]