
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, Union, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..message import TypeMessage
    from ..forum_topic import TypeForumTopic
    from ..search_posts_flood import TypeSearchPostsFlood
    from ....gadgets.byteutils import Reader


class Messages(TLObject, family='TypeMessagesMessages'):
    """
    Full list of messages with auxiliary data.
    """

    _id = 0X8C718E87
    _group_id = 0XC8BB9188

    def __init__(
        self,
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Full list of messages with auxiliary data.

        Args:
            messages (List['TypeMessage']): List of messages
            chats (List['TypeChat']): List of chats mentioned in dialogs
            users (List['TypeUser']): List of users mentioned in messages and chats
        """

        self.messages = messages
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x87\x8eq\x8c' if boxed else b'') as writer:
            writer.vector(
                self.messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            messages=messages_,
            chats=chats_,
            users=users_
        )

class MessagesSlice(TLObject, family='TypeMessagesMessages'):
    """
    Incomplete list of messages and auxiliary data.
    """

    _id = 0X762B263D
    _group_id = 0XC8BB9188

    def __init__(
        self,
        count: int,
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        inexact: bool = False,
        next_rate: Optional[int] = None,
        offset_id_offset: Optional[int] = None,
        search_flood: Optional['TypeSearchPostsFlood'] = None
    ):

        """
        Incomplete list of messages and auxiliary data.

        Args:
            count (int): Total number of messages in the list
            messages (List['TypeMessage']): List of messages
            chats (List['TypeChat']): List of chats mentioned in messages
            users (List['TypeUser']): List of users mentioned in messages and chats
            inexact (bool, optional): If set, indicates that the results may be inexact
            next_rate (Optional[int], optional): Rate to use in the offset_rate parameter in the next call to [messages.searchGlobal](https://core.telegram.org/method/messages.searchGlobal)
            offset_id_offset (Optional[int], optional): Indicates the absolute position of messages[0] within the total result set with count count. This is useful, for example, if the result was fetched using offset_id, and we need to display a progress/total counter (like photo 134 of 200, for all media in a chat, we could simply use photo ${offset_id_offset} of ${count}.
            search_flood (Optional['TypeSearchPostsFlood'], optional): ...
        """

        self.count = count
        self.messages = messages
        self.chats = chats
        self.users = users
        self.inexact = inexact
        self.next_rate = next_rate
        self.offset_id_offset = offset_id_offset
        self.search_flood = search_flood

    def to_bytes(self, boxed: bool=True):
        with Writer(b'=&+v' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.inexact, 1)
                writer.int(self.count)

                if flags(self.next_rate, 0):
                    writer.int(self.next_rate)

                if flags(self.offset_id_offset, 2):
                    writer.int(self.offset_id_offset)

                if flags(self.search_flood, 3):
                    writer.object(
                        self.search_flood,
                        group_id=0X52D3EF52
                    )
                writer.vector(
                    self.messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X25780A8F
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        next_rate_ = (
            reader.int()
            if flags(0) else None
        )

        offset_id_offset_ = (
            reader.int()
            if flags(2) else None
        )

        search_flood_ = (
            reader.object(
                group_id=0X52D3EF52
            )
            if flags(3) else None
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            messages=messages_,
            chats=chats_,
            users=users_,
            inexact=flags(1),
            next_rate=next_rate_,
            offset_id_offset=offset_id_offset_,
            search_flood=search_flood_
        )

class ChannelMessages(TLObject, family='TypeMessagesMessages'):
    """
    Channel messages
    """

    _id = 0XC776BA4E
    _group_id = 0XC8BB9188

    def __init__(
        self,
        pts: int,
        count: int,
        messages: List['TypeMessage'],
        topics: List['TypeForumTopic'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        inexact: bool = False,
        offset_id_offset: Optional[int] = None
    ):

        """
        Channel messages

        Args:
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            count (int): Total number of results were found server-side (may not be all included here)
            messages (List['TypeMessage']): Found messages
            topics (List['TypeForumTopic']): [Forum topic](https://core.telegram.org/api/forum#forum-topics) information
            chats (List['TypeChat']): Chats
            users (List['TypeUser']): Users
            inexact (bool, optional): If set, returned results may be inexact
            offset_id_offset (Optional[int], optional): Indicates the absolute position of messages[0] within the total result set with count count. This is useful, for example, if the result was fetched using offset_id, and we need to display a progress/total counter (like photo 134 of 200, for all media in a chat, we could simply use photo ${offset_id_offset} of ${count}.
        """

        self.pts = pts
        self.count = count
        self.messages = messages
        self.topics = topics
        self.chats = chats
        self.users = users
        self.inexact = inexact
        self.offset_id_offset = offset_id_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'N\xbav\xc7' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.inexact, 1)
                writer.int(self.pts)
                writer.int(self.count)

                if flags(self.offset_id_offset, 2):
                    writer.int(self.offset_id_offset)
                writer.vector(
                    self.messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X25780A8F
                    )
                )
                writer.vector(
                    self.topics,
                    lambda value: writer.object(
                        value,
                        group_id=0XB926BAD6
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        pts_ = reader.int()
        count_ = reader.int()
        offset_id_offset_ = (
            reader.int()
            if flags(2) else None
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        topics_ = reader.vector(
            lambda: reader.object(
                group_id=0XB926BAD6
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            pts=pts_,
            count=count_,
            messages=messages_,
            topics=topics_,
            chats=chats_,
            users=users_,
            inexact=flags(1),
            offset_id_offset=offset_id_offset_
        )

class MessagesNotModified(TLObject, family='TypeMessagesMessages'):
    """
    No new messages matching the query were found
    """

    _id = 0X74535F21
    _group_id = 0XC8BB9188

    def __init__(
        self,
        count: int
    ):

        """
        No new messages matching the query were found

        Args:
            count (int): Number of results found server-side by the given query
        """

        self.count = count

    def to_bytes(self, boxed: bool=True):
        with Writer(b'!_St' if boxed else b'') as writer:
            writer.int(self.count)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()

        return cls(
            count=count_
        )

TypeMessagesMessages = Union[
    Messages,
    MessagesSlice,
    ChannelMessages,
    MessagesNotModified
]