
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..encrypted_file import TypeEncryptedFile
    from ....gadgets.byteutils import Reader


class SentEncryptedMessage(TLObject, family='TypeMessagesSentEncryptedMessage'):
    """
    Message without file attachments sent to an encrypted file.
    """

    _id = 0X560F8935
    _group_id = 0XFA58ED64

    def __init__(
        self,
        date: int
    ):

        """
        Message without file attachments sent to an encrypted file.

        Args:
            date (int): Date of sending
        """

        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'5\x89\x0fV' if boxed else b'') as writer:
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        date_ = reader.int()

        return cls(
            date=date_
        )

class SentEncryptedFile(TLObject, family='TypeMessagesSentEncryptedMessage'):
    """
    Message with a file enclosure sent to a protected chat
    """

    _id = 0X9493FF32
    _group_id = 0XFA58ED64

    def __init__(
        self,
        date: int,
        file: 'TypeEncryptedFile'
    ):

        """
        Message with a file enclosure sent to a protected chat

        Args:
            date (int): Sending date
            file ('TypeEncryptedFile'): Attached file
        """

        self.date = date
        self.file = file

    def to_bytes(self, boxed: bool=True):
        with Writer(b'2\xff\x93\x94' if boxed else b'') as writer:
            writer.int(self.date)
            writer.object(
                self.file,
                group_id=0X77918D96
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        date_ = reader.int()
        file_ = reader.object(
            group_id=0X77918D96
        )

        return cls(
            date=date_,
            file=file_
        )

TypeMessagesSentEncryptedMessage = Union[
    SentEncryptedMessage,
    SentEncryptedFile
]