
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .rich_text import TypeRichText
    from ...gadgets.byteutils import Reader


class PageTableCell(TLObject, family='TypePageTableCell'):
    """
    Table cell
    """

    _id = 0X34566B6A
    _group_id = 0X4350DA02

    def __init__(
        self,
        header: bool = False,
        align_center: bool = False,
        align_right: bool = False,
        valign_middle: bool = False,
        valign_bottom: bool = False,
        text: Optional['TypeRichText'] = None,
        colspan: Optional[int] = None,
        rowspan: Optional[int] = None
    ):

        """
        Table cell

        Args:
            header (bool, optional): Is this element part of the column header
            align_center (bool, optional): Horizontally centered block
            align_right (bool, optional): Right-aligned block
            valign_middle (bool, optional): Vertically centered block
            valign_bottom (bool, optional): Block vertically-aligned to the bottom
            text (Optional['TypeRichText'], optional): Content
            colspan (Optional[int], optional): For how many columns should this cell extend
            rowspan (Optional[int], optional): For how many rows should this cell extend
        """

        self.header = header
        self.align_center = align_center
        self.align_right = align_right
        self.valign_middle = valign_middle
        self.valign_bottom = valign_bottom
        self.text = text
        self.colspan = colspan
        self.rowspan = rowspan

    def to_bytes(self, boxed: bool=True):
        with Writer(b'jkV4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.header, 0)
                flags(self.align_center, 3)
                flags(self.align_right, 4)
                flags(self.valign_middle, 5)
                flags(self.valign_bottom, 6)

                if flags(self.text, 7):
                    writer.object(
                        self.text,
                        group_id=0XB588E109
                    )

                if flags(self.colspan, 1):
                    writer.int(self.colspan)

                if flags(self.rowspan, 2):
                    writer.int(self.rowspan)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        text_ = (
            reader.object(
                group_id=0XB588E109
            )
            if flags(7) else None
        )

        colspan_ = (
            reader.int()
            if flags(1) else None
        )

        rowspan_ = (
            reader.int()
            if flags(2) else None
        )

        return cls(
            header=flags(0),
            align_center=flags(3),
            align_right=flags(4),
            valign_middle=flags(5),
            valign_bottom=flags(6),
            text=text_,
            colspan=colspan_,
            rowspan=rowspan_
        )

TypePageTableCell = PageTableCell