
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PostAddress(TLObject, family='TypePostAddress'):
    """
    Shipping address
    """

    _id = 0X1E8CAAEB
    _group_id = 0X7BF3C2EF

    def __init__(
        self,
        street_line1: str,
        street_line2: str,
        city: str,
        state: str,
        country_iso2: str,
        post_code: str
    ):

        """
        Shipping address

        Args:
            street_line1 (str): First line for the address
            street_line2 (str): Second line for the address
            city (str): City
            state (str): State, if applicable (empty otherwise)
            country_iso2 (str): ISO 3166-1 alpha-2 country code
            post_code (str): Address post code
        """

        self.street_line1 = street_line1
        self.street_line2 = street_line2
        self.city = city
        self.state = state
        self.country_iso2 = country_iso2
        self.post_code = post_code

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeb\xaa\x8c\x1e' if boxed else b'') as writer:
            writer.string(self.street_line1)
            writer.string(self.street_line2)
            writer.string(self.city)
            writer.string(self.state)
            writer.string(self.country_iso2)
            writer.string(self.post_code)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        street_line1_ = reader.string()
        street_line2_ = reader.string()
        city_ = reader.string()
        state_ = reader.string()
        country_iso2_ = reader.string()
        post_code_ = reader.string()

        return cls(
            street_line1=street_line1_,
            street_line2=street_line2_,
            city=city_,
            state=state_,
            country_iso2=country_iso2_,
            post_code=post_code_
        )

TypePostAddress = PostAddress