
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..boost import TypeBoost
    from ....gadgets.byteutils import Reader


class BoostsList(TLObject, family='TypePremiumBoostsList'):
    """
    List of [boosts](https://core.telegram.org/api/boost) that were applied to a peer by multiple users.
    """

    _id = 0X86F8613C
    _group_id = 0X70580F5F

    def __init__(
        self,
        count: int,
        boosts: List['TypeBoost'],
        users: List['TypeUser'],
        next_offset: Optional[str] = None
    ):

        """
        List of [boosts](https://core.telegram.org/api/boost) that were applied to a peer by multiple users.

        Args:
            count (int): Total number of results
            boosts (List['TypeBoost']): [Boosts](https://core.telegram.org/api/boost)
            users (List['TypeUser']): Mentioned users
            next_offset (Optional[str], optional): Offset that can be used for [pagination](https://core.telegram.org/api/offsets).
        """

        self.count = count
        self.boosts = boosts
        self.users = users
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'<a\xf8\x86' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.count)
                writer.vector(
                    self.boosts,
                    lambda value: writer.object(
                        value,
                        group_id=0X9F7E3FDC
                    )
                )

                if flags(self.next_offset, 0):
                    writer.string(self.next_offset)
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        boosts_ = reader.vector(
            lambda: reader.object(
                group_id=0X9F7E3FDC
            )
        )

        next_offset_ = (
            reader.string()
            if flags(0) else None
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            boosts=boosts_,
            users=users_,
            next_offset=next_offset_
        )

TypePremiumBoostsList = BoostsList