
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PrivacyValueAllowContacts(TLObject, family='TypePrivacyRule'):
    """
    Allow all contacts
    """

    _id = 0XFFFE1BAC
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b'\xac\x1b\xfe\xff' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PrivacyValueAllowAll(TLObject, family='TypePrivacyRule'):
    """
    Allow all users
    """

    _id = 0X65427B82
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b'\x82{Be' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PrivacyValueAllowUsers(TLObject, family='TypePrivacyRule'):
    """
    Allow only certain users
    """

    _id = 0XB8905FB2
    _group_id = 0X1D3AEAB3

    def __init__(
        self,
        users: List[int]
    ):

        """
        Allow only certain users

        Args:
            users (List[int]): Allowed users
        """

        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb2_\x90\xb8' if boxed else b'') as writer:
            writer.vector(
                self.users,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        users_ = reader.vector(
            reader.long
        )

        return cls(
            users=users_
        )

class PrivacyValueDisallowContacts(TLObject, family='TypePrivacyRule'):
    """
    Disallow only contacts
    """

    _id = 0XF888FA1A
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b'\x1a\xfa\x88\xf8' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PrivacyValueDisallowAll(TLObject, family='TypePrivacyRule'):
    """
    Disallow all users
    """

    _id = 0X8B73E763
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b'c\xe7s\x8b' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PrivacyValueDisallowUsers(TLObject, family='TypePrivacyRule'):
    """
    Disallow only certain users
    """

    _id = 0XE4621141
    _group_id = 0X1D3AEAB3

    def __init__(
        self,
        users: List[int]
    ):

        """
        Disallow only certain users

        Args:
            users (List[int]): Disallowed users
        """

        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'A\x11b\xe4' if boxed else b'') as writer:
            writer.vector(
                self.users,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        users_ = reader.vector(
            reader.long
        )

        return cls(
            users=users_
        )

class PrivacyValueAllowChatParticipants(TLObject, family='TypePrivacyRule'):
    """
    Allow all participants of certain chats
    """

    _id = 0X6B134E8E
    _group_id = 0X1D3AEAB3

    def __init__(
        self,
        chats: List[int]
    ):

        """
        Allow all participants of certain chats

        Args:
            chats (List[int]): Allowed chats
        """

        self.chats = chats

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8eN\x13k' if boxed else b'') as writer:
            writer.vector(
                self.chats,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chats_ = reader.vector(
            reader.long
        )

        return cls(
            chats=chats_
        )

class PrivacyValueDisallowChatParticipants(TLObject, family='TypePrivacyRule'):
    """
    Disallow only participants of certain chats
    """

    _id = 0X41C87565
    _group_id = 0X1D3AEAB3

    def __init__(
        self,
        chats: List[int]
    ):

        """
        Disallow only participants of certain chats

        Args:
            chats (List[int]): Disallowed chats
        """

        self.chats = chats

    def to_bytes(self, boxed: bool=True):
        with Writer(b'eu\xc8A' if boxed else b'') as writer:
            writer.vector(
                self.chats,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        chats_ = reader.vector(
            reader.long
        )

        return cls(
            chats=chats_
        )

class PrivacyValueAllowCloseFriends(TLObject, family='TypePrivacyRule'):
    """
    Allow only [close friends](https://core.telegram.org/api/privacy)
    """

    _id = 0XF7E8D89B
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b'\x9b\xd8\xe8\xf7' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PrivacyValueAllowPremium(TLObject, family='TypePrivacyRule'):
    """
    Allow only users with a [Premium subscription](https://core.telegram.org/api/premium), currently only usable for [inputPrivacyKeyChatInvite](https://core.telegram.org/constructor/inputPrivacyKeyChatInvite).
    """

    _id = 0XECE9814B
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b'K\x81\xe9\xec' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PrivacyValueAllowBots(TLObject, family='TypePrivacyRule'):
    """
    Allow bots and mini apps
    """

    _id = 0X21461B5D
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b']\x1bF!' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class PrivacyValueDisallowBots(TLObject, family='TypePrivacyRule'):
    """
    Disallow bots and mini apps
    """

    _id = 0XF6A5F82F
    _group_id = 0X1D3AEAB3


    def to_bytes(self, boxed: bool=True):
        return b'/\xf8\xa5\xf6' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypePrivacyRule = Union[
    PrivacyValueAllowContacts,
    PrivacyValueAllowAll,
    PrivacyValueAllowUsers,
    PrivacyValueDisallowContacts,
    PrivacyValueDisallowAll,
    PrivacyValueDisallowUsers,
    PrivacyValueAllowChatParticipants,
    PrivacyValueDisallowChatParticipants,
    PrivacyValueAllowCloseFriends,
    PrivacyValueAllowPremium,
    PrivacyValueAllowBots,
    PrivacyValueDisallowBots
]