
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .chat_invite import TypeChatInvite
    from ...gadgets.byteutils import Reader
    from .sticker_set_covered import TypeStickerSetCovered


class RecentMeUrlUnknown(TLObject, family='TypeRecentMeUrl'):
    """
    Unknown t.me url
    """

    _id = 0X46E1D13D
    _group_id = 0XA32828BA

    def __init__(
        self,
        url: str
    ):

        """
        Unknown t.me url

        Args:
            url (str): URL
        """

        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'=\xd1\xe1F' if boxed else b'') as writer:
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()

        return cls(
            url=url_
        )

class RecentMeUrlUser(TLObject, family='TypeRecentMeUrl'):
    """
    Recent t.me link to a user
    """

    _id = 0XB92C09E2
    _group_id = 0XA32828BA

    def __init__(
        self,
        url: str,
        user_id: int
    ):

        """
        Recent t.me link to a user

        Args:
            url (str): URL
            user_id (int): User ID
        """

        self.url = url
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe2\t,\xb9' if boxed else b'') as writer:
            writer.string(self.url)
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        user_id_ = reader.long()

        return cls(
            url=url_,
            user_id=user_id_
        )

class RecentMeUrlChat(TLObject, family='TypeRecentMeUrl'):
    """
    Recent t.me link to a chat
    """

    _id = 0XB2DA71D2
    _group_id = 0XA32828BA

    def __init__(
        self,
        url: str,
        chat_id: int
    ):

        """
        Recent t.me link to a chat

        Args:
            url (str): t.me URL
            chat_id (int): Chat ID
        """

        self.url = url
        self.chat_id = chat_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd2q\xda\xb2' if boxed else b'') as writer:
            writer.string(self.url)
            writer.long(self.chat_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        chat_id_ = reader.long()

        return cls(
            url=url_,
            chat_id=chat_id_
        )

class RecentMeUrlChatInvite(TLObject, family='TypeRecentMeUrl'):
    """
    Recent t.me invite link to a chat
    """

    _id = 0XEB49081D
    _group_id = 0XA32828BA

    def __init__(
        self,
        url: str,
        chat_invite: 'TypeChatInvite'
    ):

        """
        Recent t.me invite link to a chat

        Args:
            url (str): t.me URL
            chat_invite ('TypeChatInvite'): Chat invitation
        """

        self.url = url
        self.chat_invite = chat_invite

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1d\x08I\xeb' if boxed else b'') as writer:
            writer.string(self.url)
            writer.object(
                self.chat_invite,
                group_id=0X30688FE3
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        chat_invite_ = reader.object(
            group_id=0X30688FE3
        )

        return cls(
            url=url_,
            chat_invite=chat_invite_
        )

class RecentMeUrlStickerSet(TLObject, family='TypeRecentMeUrl'):
    """
    Recent t.me stickerset installation URL
    """

    _id = 0XBC0A57DC
    _group_id = 0XA32828BA

    def __init__(
        self,
        url: str,
        set: 'TypeStickerSetCovered'
    ):

        """
        Recent t.me stickerset installation URL

        Args:
            url (str): t.me URL
            set ('TypeStickerSetCovered'): Stickerset
        """

        self.url = url
        self.set = set

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xdcW\n\xbc' if boxed else b'') as writer:
            writer.string(self.url)
            writer.object(
                self.set,
                group_id=0X16103538
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        set_ = reader.object(
            group_id=0X16103538
        )

        return cls(
            url=url_,
            set=set_
        )

TypeRecentMeUrl = Union[
    RecentMeUrlUnknown,
    RecentMeUrlUser,
    RecentMeUrlChat,
    RecentMeUrlChatInvite,
    RecentMeUrlStickerSet
]