
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from ...gadgets.byteutils import Reader


class RequestedPeerUser(TLObject, family='TypeRequestedPeer'):
    """
    Info about a user, shared by a user with the currently logged in bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).
    """

    _id = 0XD62FF46A
    _group_id = 0X31339646

    def __init__(
        self,
        user_id: int,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        username: Optional[str] = None,
        photo: Optional['TypePhoto'] = None
    ):

        """
        Info about a user, shared by a user with the currently logged in bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).

        Args:
            user_id (int): User ID.
            first_name (Optional[str], optional): First name.
            last_name (Optional[str], optional): Last name.
            username (Optional[str], optional): Username.
            photo (Optional['TypePhoto'], optional): Profile photo.
        """

        self.user_id = user_id
        self.first_name = first_name
        self.last_name = last_name
        self.username = username
        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'j\xf4/\xd6' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.user_id)

                if flags(self.first_name, 0):
                    writer.string(self.first_name)

                if flags(self.last_name, 0):
                    writer.string(self.last_name)

                if flags(self.username, 1):
                    writer.string(self.username)

                if flags(self.photo, 2):
                    writer.object(
                        self.photo,
                        group_id=0XDDAD9CAC
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        first_name_ = (
            reader.string()
            if flags(0) else None
        )

        last_name_ = (
            reader.string()
            if flags(0) else None
        )

        username_ = (
            reader.string()
            if flags(1) else None
        )

        photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(2) else None
        )

        return cls(
            user_id=user_id_,
            first_name=first_name_,
            last_name=last_name_,
            username=username_,
            photo=photo_
        )

class RequestedPeerChat(TLObject, family='TypeRequestedPeer'):
    """
    Info about a [chat](https://core.telegram.org/api/channel), shared by a user with the currently logged in bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).
    """

    _id = 0X7307544F
    _group_id = 0X31339646

    def __init__(
        self,
        chat_id: int,
        title: Optional[str] = None,
        photo: Optional['TypePhoto'] = None
    ):

        """
        Info about a [chat](https://core.telegram.org/api/channel), shared by a user with the currently logged in bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).

        Args:
            chat_id (int): Chat ID.
            title (Optional[str], optional): Chat title.
            photo (Optional['TypePhoto'], optional): Chat photo.
        """

        self.chat_id = chat_id
        self.title = title
        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'OT\x07s' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.chat_id)

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.photo, 2):
                    writer.object(
                        self.photo,
                        group_id=0XDDAD9CAC
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        chat_id_ = reader.long()
        title_ = (
            reader.string()
            if flags(0) else None
        )

        photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(2) else None
        )

        return cls(
            chat_id=chat_id_,
            title=title_,
            photo=photo_
        )

class RequestedPeerChannel(TLObject, family='TypeRequestedPeer'):
    """
    Info about a [channel/supergroup](https://core.telegram.org/api/channel), shared by a user with the currently logged in bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).
    """

    _id = 0X8BA403E4
    _group_id = 0X31339646

    def __init__(
        self,
        channel_id: int,
        title: Optional[str] = None,
        username: Optional[str] = None,
        photo: Optional['TypePhoto'] = None
    ):

        """
        Info about a [channel/supergroup](https://core.telegram.org/api/channel), shared by a user with the currently logged in bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).

        Args:
            channel_id (int): Channel/supergroup ID.
            title (Optional[str], optional): Channel/supergroup title.
            username (Optional[str], optional): Channel/supergroup username.
            photo (Optional['TypePhoto'], optional): Channel/supergroup photo.
        """

        self.channel_id = channel_id
        self.title = title
        self.username = username
        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe4\x03\xa4\x8b' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.channel_id)

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.username, 1):
                    writer.string(self.username)

                if flags(self.photo, 2):
                    writer.object(
                        self.photo,
                        group_id=0XDDAD9CAC
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        title_ = (
            reader.string()
            if flags(0) else None
        )

        username_ = (
            reader.string()
            if flags(1) else None
        )

        photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(2) else None
        )

        return cls(
            channel_id=channel_id_,
            title=title_,
            username=username_,
            photo=photo_
        )

TypeRequestedPeer = Union[
    RequestedPeerUser,
    RequestedPeerChat,
    RequestedPeerChannel
]