
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .draft_message import TypeDraftMessage
    from ...gadgets.byteutils import Reader


class SavedDialog(TLObject, family='TypeSavedDialog'):
    """
    Represents a [saved dialog](https://core.telegram.org/api/saved-messages).
    """

    _id = 0XBD87CB6C
    _group_id = 0XD5377DC5

    def __init__(
        self,
        peer: 'TypePeer',
        top_message: int,
        pinned: bool = False
    ):

        """
        Represents a [saved dialog](https://core.telegram.org/api/saved-messages).

        Args:
            peer ('TypePeer'): The dialog
            top_message (int): The latest message ID
            pinned (bool, optional): Is the dialog pinned
        """

        self.peer = peer
        self.top_message = top_message
        self.pinned = pinned

    def to_bytes(self, boxed: bool=True):
        with Writer(b'l\xcb\x87\xbd' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pinned, 2)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.top_message)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        top_message_ = reader.int()

        return cls(
            peer=peer_,
            top_message=top_message_,
            pinned=flags(2)
        )

class MonoForumDialog(TLObject, family='TypeSavedDialog'):
    _id = 0X64407EA7
    _group_id = 0XD5377DC5

    def __init__(
        self,
        peer: 'TypePeer',
        top_message: int,
        read_inbox_max_id: int,
        read_outbox_max_id: int,
        unread_count: int,
        unread_reactions_count: int,
        unread_mark: bool = False,
        nopaid_messages_exception: bool = False,
        draft: Optional['TypeDraftMessage'] = None
    ):

        self.peer = peer
        self.top_message = top_message
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.unread_reactions_count = unread_reactions_count
        self.unread_mark = unread_mark
        self.nopaid_messages_exception = nopaid_messages_exception
        self.draft = draft

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa7~@d' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.unread_mark, 3)
                flags(self.nopaid_messages_exception, 4)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.top_message)
                writer.int(self.read_inbox_max_id)
                writer.int(self.read_outbox_max_id)
                writer.int(self.unread_count)
                writer.int(self.unread_reactions_count)

                if flags(self.draft, 1):
                    writer.object(
                        self.draft,
                        group_id=0X314F6157
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        top_message_ = reader.int()
        read_inbox_max_id_ = reader.int()
        read_outbox_max_id_ = reader.int()
        unread_count_ = reader.int()
        unread_reactions_count_ = reader.int()
        draft_ = (
            reader.object(
                group_id=0X314F6157
            )
            if flags(1) else None
        )

        return cls(
            peer=peer_,
            top_message=top_message_,
            read_inbox_max_id=read_inbox_max_id_,
            read_outbox_max_id=read_outbox_max_id_,
            unread_count=unread_count_,
            unread_reactions_count=unread_reactions_count_,
            unread_mark=flags(3),
            nopaid_messages_exception=flags(4),
            draft=draft_
        )

TypeSavedDialog = Union[
    SavedDialog,
    MonoForumDialog
]