
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .stars_giveaway_winners_option import TypeStarsGiveawayWinnersOption


class StarsGiveawayOption(TLObject, family='TypeStarsGiveawayOption'):
    """
    Contains info about a [Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways) option.
    """

    _id = 0X94CE852A
    _group_id = 0XFF6A928D

    def __init__(
        self,
        stars: int,
        yearly_boosts: int,
        currency: str,
        amount: int,
        winners: List['TypeStarsGiveawayWinnersOption'],
        extended: bool = False,
        default: bool = False,
        store_product: Optional[str] = None
    ):

        """
        Contains info about a [Telegram Star giveaway](https://core.telegram.org/api/giveaways#star-giveaways) option.

        Args:
            stars (int): The number of Telegram Stars that will be distributed among winners
            yearly_boosts (int): Number of times the chat will be boosted for one year if the [inputStorePaymentStarsGiveaway](https://core.telegram.org/constructor/inputStorePaymentStarsGiveaway). boost_peer flag is populated
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            winners (List['TypeStarsGiveawayWinnersOption']): Allowed options for the number of giveaway winners.
            extended (bool, optional): If set, this option must only be shown in the full list of giveaway options (i.e. they must be added to the list only when the user clicks on the expand button).
            default (bool, optional): If set, this option must be pre-selected by default in the option list.
            store_product (Optional[str], optional): Identifier of the store product associated with the option, official apps only.
        """

        self.stars = stars
        self.yearly_boosts = yearly_boosts
        self.currency = currency
        self.amount = amount
        self.winners = winners
        self.extended = extended
        self.default = default
        self.store_product = store_product

    def to_bytes(self, boxed: bool=True):
        with Writer(b'*\x85\xce\x94' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.extended, 0)
                flags(self.default, 1)
                writer.long(self.stars)
                writer.int(self.yearly_boosts)

                if flags(self.store_product, 2):
                    writer.string(self.store_product)
                writer.string(self.currency)
                writer.long(self.amount)
                writer.vector(
                    self.winners,
                    lambda value: writer.object(
                        value,
                        group_id=0X77E66F9C
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_ = reader.long()
        yearly_boosts_ = reader.int()
        store_product_ = (
            reader.string()
            if flags(2) else None
        )

        currency_ = reader.string()
        amount_ = reader.long()
        winners_ = reader.vector(
            lambda: reader.object(
                group_id=0X77E66F9C
            )
        )

        return cls(
            stars=stars_,
            yearly_boosts=yearly_boosts_,
            currency=currency_,
            amount=amount_,
            winners=winners_,
            extended=flags(0),
            default=flags(1),
            store_product=store_product_
        )

TypeStarsGiveawayOption = StarsGiveawayOption