
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class Timezone(TLObject, family='TypeTimezone'):
    """
    Timezone information.
    """

    _id = 0XFF9289F5
    _group_id = 0X8A2F85B1

    def __init__(
        self,
        id: str,
        name: str,
        utc_offset: int
    ):

        """
        Timezone information.

        Args:
            id (str): Unique timezone ID.
            name (str): Human-readable and localized timezone name.
            utc_offset (int): UTC offset in seconds, which may be displayed in hh:mm format by the client together with the human-readable name (i.e. $name UTC -01:00).
        """

        self.id = id
        self.name = name
        self.utc_offset = utc_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf5\x89\x92\xff' if boxed else b'') as writer:
            writer.string(self.id)
            writer.string(self.name)
            writer.int(self.utc_offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.string()
        name_ = reader.string()
        utc_offset_ = reader.int()

        return cls(
            id=id_,
            name=name_,
            utc_offset=utc_offset_
        )

TypeTimezone = Timezone